<?php  

/* =========================================================== */
/* 00. TGM Plugin Activation 
/* =========================================================== */
add_action('tgmpa_register', 'pixomi_register_required_plugins');
function pixomi_register_required_plugins() {
	
	$plugins = array(

		// Pixomi Core Plugin
		array(
			'name'     				=> esc_html__( 'Pixomi Core Plugin', 'pixomi' ), 
			'slug'     				=> 'pixomi_core', 
			'source'   				=> get_template_directory().'/plugins/pixomi_core.zip', 
			'version' 				=> '1.0',
			'required' 				=> true, 
			'force_activation' 		=> false, 
			'force_deactivation' 	=> false, 
			'external_url' 			=> '',
		),

		// Visual Composer
		array(
			'name'     				=> esc_html__( 'Visual Composer', 'pixomi' ), 
			'slug'     				=> 'js_composer', 
			'source'   				=> get_template_directory().'/plugins/js_composer.zip', 
			'required' 				=> true, 
			'version' 				=> '', 
			'force_activation' 		=> false,
			'force_deactivation' 	=> false, 
			'external_url' 			=> '', 
		),

		// Revolution Slider
		array(
			'name'     				=> esc_html__( 'Revolution Slider', 'pixomi' ), 
			'slug'     				=> 'revslider', 
			'source'   				=> get_template_directory().'/plugins/revslider.zip', 
			'required' 				=> true, 
			'version' 				=> '', 
			'force_activation' 		=> false,
			'force_deactivation' 	=> false, 
			'external_url' 			=> '', 
		),

		// Contact Form 7
		array(
        	'name'      		=> esc_html__( 'Contact Form 7', 'pixomi' ),
        	'slug'      		=> 'contact-form-7',
        	'required'  		=> true,
        	'force_activation'	=> false,
        ),

        // MailChimp for WordPress
		array(
        	'name'      		=> esc_html__( 'MailChimp for WordPress', 'pixomi' ),
        	'slug'      		=> 'mailchimp-for-wp',
        	'required'  		=> true,
        	'force_activation'	=> false,
        ),

        // Woo Sidebars
		array(
        	'name'      		=> esc_html__( 'WooSidebars', 'pixomi' ),
        	'slug'      		=> 'woosidebars',
        	'required'  		=> true,
        	'force_activation'	=> false,
        ),
	);

	$config = array(
		'id'           => 'tgmpa',                 
		'default_path' => '',                      
		'menu'         => 'tgmpa-install-plugins', 
		'parent_slug'  => 'themes.php',            
		'capability'   => 'edit_theme_options',    
		'has_notices'  => true,                    
		'dismissable'  => true,                    
		'dismiss_msg'  => '',                      
		'is_automatic' => false,                   
		'message'      => '',                      
	);

	tgmpa($plugins, $config);
}