<?php

// Register Widget
function pixomi_register_social_icons_widget() {
	register_widget('Pixomi_Social_Widget');
}
add_action('widgets_init', 'pixomi_register_social_icons_widget');

// Extend Widget Class
if ( ! class_exists( 'Pixomi_Social_Widget' ) ){

	class Pixomi_Social_Widget extends WP_Widget {

		// Construct Widgetz
		function __construct() {

			$widget_ops = array( 'classname' => 'social-widget', 'description' => esc_html__( 'A Widget to display Social Icons.', 'pixomi' ) );
			parent::__construct( 'pixomi_widget_social', esc_html__( 'Pixomi : Social Icons Widget', 'pixomi' ), $widget_ops );
		}

		// Output Widget
		function widget( $args, $instance ) {
			extract( $args );

			$title = apply_filters( 'widget_title', $instance['title'] );
			$twitter_id = strip_tags( $instance['twitter_id'] );
			$facebook_id = strip_tags( $instance['facebook_id'] );
			$gplus_id = strip_tags( $instance['gplus_id'] );
			$youtube_id = strip_tags( $instance['youtube_id'] );
			$flickr_id = strip_tags( $instance['flickr_id'] );
			$linkedin_id = strip_tags( $instance['linkedin_id'] );
			$pinterest_id = strip_tags( $instance['pinterest_id'] );
			$dribbble_id = strip_tags( $instance['dribbble_id'] );
			$github_id = strip_tags( $instance['github_id'] );
			$vimeo_id = strip_tags( $instance['vimeo_id'] );
			$tumblr_id = strip_tags( $instance['tumblr_id'] );
			$instagram_id = strip_tags( $instance['instagram_id'] );
			$soundcloud_id = strip_tags( $instance['soundcloud_id'] );
			$behance_id = strip_tags( $instance['behance_id'] );
			$rss = $instance['rss'];

			printf( '%s', $args['before_widget'] );
			if ( $title ) {
				printf( '%s', $args['before_title'] . $title . $args['after_title'] );
			}
			?>

			<div class="social-icons">

				<!-- Twitter -->
				<?php if ( $twitter_id ) { ?>
					<span><a class="twitter" href="<?php echo esc_attr( $twitter_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Twitter', 'pixomi' ); ?>"><i class="fa fa-twitter"></i></a></span>
				<!-- Facebook -->
				<?php } if ( $facebook_id ) { ?>
					<span><a class="facebook" href="<?php echo esc_attr( $facebook_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Facebook', 'pixomi' ); ?>"><i class="fa fa-facebook"></i></a></span>
				<!-- Linkedin -->
				<?php } if ( $linkedin_id ) { ?>
					<span><a class="linkedin" href="<?php echo esc_attr( $linkedin_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Linkedin', 'pixomi' ); ?>"><i class="fa fa-linkedin"></i></a></span>				
				<!-- Google Plus -->
				<?php } if ( $gplus_id ) { ?>
					<span><a class="google-plus" href="<?php echo esc_attr( $gplus_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Google Plus', 'pixomi' ); ?>"><i class="fa fa-google-plus"></i></a></span>
				<!-- Instagram -->
				<?php } if ( $instagram_id ) { ?>
					<span><a class="instagram" href="<?php echo esc_attr( $instagram_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Instagram', 'pixomi' ); ?>"><i class="fa fa-instagram"></i></a></span>
				<!-- Pinterest -->
				<?php } if ( $pinterest_id ) { ?>
					<span><a class="pinterest" href="<?php echo esc_attr( $pinterest_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Pinterest', 'pixomi' ); ?>"><i class="fa fa-pinterest"></i></a></span>
				<!-- Youtube -->
				<?php } if ( $youtube_id ) { ?>
					<span><a class="youtube" href="<?php echo esc_attr( $youtube_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Youtube', 'pixomi' ); ?>"><i class="fa fa-youtube"></i></a></span>
				<!-- Vimeo -->
				<?php } if ( $vimeo_id ) { ?>
					<span><a class="vimeo" href="<?php echo esc_attr( $vimeo_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Vimeo', 'pixomi' ); ?>"><i class="fa fa-vimeo-square"></i></a></span>
				<!-- Flickr -->
				<?php } if ( $flickr_id ) { ?>
					<span><a class="flickr" href="<?php echo esc_attr( $flickr_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Flickr', 'pixomi' ); ?>"><i class="fa fa-flickr"></i></a></span>
				<!-- Tumblr -->
				<?php } if ( $tumblr_id ) { ?>
					<span><a class="tumblr" href="<?php echo esc_attr( $tumblr_id ); ?>.tumblr.com" target="_blank" title="<?php esc_html_e( 'Follow Us on Tumblr', 'pixomi' ); ?>"><i class="fa fa-tumblr"></i></a></span>
				<!-- Behance -->
				<?php } if ( $behance_id ) { ?>
					<span><a class="behance" href="<?php echo esc_attr( $behance_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Behance', 'pixomi' ); ?>"><i class="fa fa-behance"></i></a></span>
				<!-- Dribble -->
				<?php } if ( $dribbble_id ) { ?>
					<span><a class="dribbble" href="<?php echo esc_attr( $dribbble_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Dribble', 'pixomi' ); ?>"><i class="fa fa-dribbble"></i></a></span>
				<!-- SoundCloud -->
				<?php } if ( $soundcloud_id ) { ?>
					<span><a class="soundcloud" href="<?php echo esc_attr( $soundcloud_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on SoundCloud', 'pixomi' ); ?>"><i class="fa fa-soundcloud"></i></a></span>
				<!-- Github -->
				<?php } if ( $github_id ) { ?>
					<span><a class="github" href="<?php echo esc_attr( $github_id ); ?>" target="_blank" title="<?php esc_html_e( 'Follow Us on Github', 'pixomi' ); ?>"><i class="fa fa-github"></i></a></span>
				<!-- Rss -->
				<?php } if ( $rss ) { ?>
					<span><a class="rss" href="<?php echo esc_url( $rss ); ?>" target="_blank"><i class="fa fa-rss"></i></a></span>
				<?php } ?>

			</div>

			<?php
			printf( '%s', $args['after_widget'] );

		}

		// Update Widget
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			$instance['title'] = strip_tags( $new_instance['title'] );
			$instance['twitter_id'] = strip_tags( $new_instance['twitter_id'] );
			$instance['facebook_id'] = strip_tags( $new_instance['facebook_id'] );
			$instance['gplus_id'] = strip_tags( $new_instance['gplus_id'] );
			$instance['youtube_id'] = strip_tags( $new_instance['youtube_id'] );
			$instance['flickr_id'] = strip_tags( $new_instance['flickr_id'] );
			$instance['linkedin_id'] = strip_tags( $new_instance['linkedin_id'] );
			$instance['pinterest_id'] = strip_tags( $new_instance['pinterest_id'] );
			$instance['dribbble_id'] = strip_tags( $new_instance['dribbble_id'] );
			$instance['github_id'] = strip_tags( $new_instance['github_id'] );
			$instance['vimeo_id'] = strip_tags( $new_instance['vimeo_id'] );
			$instance['tumblr_id'] = strip_tags( $new_instance['tumblr_id'] );
			$instance['instagram_id'] = strip_tags( $new_instance['instagram_id'] );
			$instance['soundcloud_id'] = strip_tags( $new_instance['soundcloud_id'] );
			$instance['behance_id'] = strip_tags( $new_instance['behance_id'] );
			$instance['rss'] = esc_url_raw( $new_instance['rss'] );

			return $instance;
		}

		// Widget Form
		function form( $instance ) {

	        $defaults = array(
	            'title' => '',
	            'twitter_id' => '',
	            'facebook_id' => '',
	            'gplus_id' => '',
	            'youtube_id' => '',
	            'flickr_id' => '',
	            'linkedin_id' => '',
	            'pinterest_id' => '',
	            'dribbble_id' => '',
	            'github_id' => '',
	            'vimeo_id' => '',
	            'tumblr_id' => '',
	            'instagram_id' => '',
	            'soundcloud_id' => '',
	            'behance_id' => '',
	            'rss' => ''
	        );
	        $instance = wp_parse_args( (array) $instance, $defaults );
			$title = strip_tags( $instance['title'] );
			$twitter_id = strip_tags( $instance['twitter_id'] );
			$facebook_id = strip_tags( $instance['facebook_id'] );
			$gplus_id = strip_tags( $instance['gplus_id'] );
			$youtube_id = strip_tags( $instance['youtube_id'] );
			$flickr_id = strip_tags( $instance['flickr_id'] );
			$linkedin_id = strip_tags( $instance['linkedin_id'] );
			$pinterest_id = strip_tags( $instance['pinterest_id'] );
			$dribbble_id = strip_tags( $instance['dribbble_id'] );
			$github_id = strip_tags( $instance['github_id'] );
			$vimeo_id = strip_tags( $instance['vimeo_id'] );
			$tumblr_id = strip_tags( $instance['tumblr_id'] );
			$instagram_id = strip_tags( $instance['instagram_id'] );
			$soundcloud_id = strip_tags( $instance['soundcloud_id'] );
			$behance_id = strip_tags( $instance['behance_id'] );
			$rss = esc_url_raw( $instance['rss'] );

		?>
			<!-- Title -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			
			<p><?php esc_html_e('If you Dont Want to use Any Social Profile Just Leave it Blank', 'pixomi'); ?></p>

			<!-- Twitter -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'twitter_id' ) ); ?>"><?php esc_html_e( 'Twitter Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'twitter_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twitter_id' ) ); ?>" value="<?php echo esc_attr( $twitter_id ); ?>" />
			</p>
			<!-- Facebook -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'facebook_id' ) ); ?>"><?php esc_html_e( 'Facebook Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'facebook_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'facebook_id' ) ); ?>" value="<?php echo esc_attr( $facebook_id ); ?>" />
			</p>
			<!-- Linkedin -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'linkedin_id' ) ); ?>"><?php esc_html_e( 'Linkedin Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'linkedin_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'linkedin_id' ) ); ?>" value="<?php echo esc_attr( $linkedin_id ); ?>" />
			</p>
			<!-- Google Plus -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'gplus_id' ) ); ?>"><?php esc_html_e( 'Google Plus Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'gplus_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'gplus_id' ) ); ?>" value="<?php echo esc_attr( $gplus_id ); ?>" />
			</p>
			<!-- Instagram -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'instagram_id' ) ); ?>"><?php esc_html_e( 'Instagram Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'instagram_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'instagram_id' ) ); ?>" value="<?php echo esc_attr( $instagram_id ); ?>" />
			</p>
			<!-- Pinterest -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'pinterest_id' ) ); ?>"><?php esc_html_e( 'Pinterest Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'pinterest_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'pinterest_id' ) ); ?>" value="<?php echo esc_attr( $pinterest_id ); ?>" />
			</p>
			<!-- Youtube -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'youtube_id' ) ); ?>"><?php esc_html_e( 'Youtube Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'youtube_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'youtube_id' ) ); ?>" value="<?php echo esc_attr( $youtube_id ); ?>" />
			</p>
			<!-- Vimeo -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'vimeo_id' ) ); ?>"><?php esc_html_e( 'Vimeo Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'vimeo_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'vimeo_id' ) ); ?>" value="<?php echo esc_attr( $vimeo_id ); ?>" />
			</p>
			<!-- Flickr -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'flickr_id' ) ); ?>"><?php esc_html_e( 'Flickr Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'flickr_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'flickr_id' ) ); ?>" value="<?php echo esc_attr( $flickr_id ); ?>" />
			</p>
			<!-- Tumblr -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'tumblr_id' ) ); ?>"><?php esc_html_e( 'Tumblr Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'tumblr_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'tumblr_id' ) ); ?>" value="<?php echo esc_attr( $tumblr_id ); ?>" />
			</p>
			<!-- Behance -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'behance_id' ) ); ?>"><?php esc_html_e( 'Behance Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'behance_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'behance_id' ) ); ?>" value="<?php echo esc_attr( $behance_id ); ?>" />
			</p>
			<!-- Dribble -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'dribbble_id' ) ); ?>"><?php esc_html_e( 'Dribbble Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'dribbble_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'dribbble_id' ) ); ?>" value="<?php echo esc_attr( $dribbble_id ); ?>" />
			</p>
			<!-- SoundCloud -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'soundcloud_id' ) ); ?>"><?php esc_html_e( 'Soundcloud Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'soundcloud_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'soundcloud_id' ) ); ?>" value="<?php echo esc_attr( $soundcloud_id ); ?>" />
			</p>
			<!-- Github -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'github_id' ) ); ?>"><?php esc_html_e( 'Github Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'github_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'github_id' ) ); ?>" value="<?php echo esc_attr( $github_id ); ?>" />
			</p>
			<!-- Rss Url -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'rss' ) ); ?>"><?php esc_html_e( 'Rss URL Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'rss' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'rss' ) ); ?>" value="<?php echo esc_attr( $rss ); ?>" />
			</p>

		<?php

		}
	}
}