<?php

// Register Widget
function pixomi_register_contact_info_widget() {
	register_widget( 'Pixomi_Contact_Info_Widget' );
}
add_action( 'widgets_init', 'pixomi_register_contact_info_widget' );

// Extend Widget Class
if ( ! class_exists( 'Pixomi_Contact_Info_Widget' ) ){
	
	class Pixomi_Contact_Info_Widget extends WP_Widget {

		// Construct Widget
		function __construct() {
			$widget_ops	 = array( 'classname' => 'contact-widget', 'description' => esc_html__('Show your Contact Information.', 'pixomi') );
			$control_ops = array( 'id_base' => 'pixomi_widget_contact_info' );
			parent::__construct( 'pixomi_widget_contact_info', esc_html__( 'Pixomi : Contact Info Widget', 'pixomi' ), $widget_ops, $control_ops );
		}
		
		// Output Widget
		function widget( $args, $instance ) {
			extract( $args );
			
			$defaults	 = array(
				'title'		 => esc_html__('Contact Info','pixomi'), 
				'desc'	     => '',
				'address'	 => '',
				'phone'		 => '',
				'fax'		 => '',
				'email'		 => '',
				'web'		 => '',
			);
			$instance	 = wp_parse_args( (array) $instance, $defaults );
			$title = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );

			echo $before_widget;
			if ( !empty( $title ) ) {
				echo $before_title;
				echo $title;
				echo $after_title;
			} ?>
			
			<div class="contact-info">

				<!-- Desc -->
				<?php if( !empty( $instance['desc'] ) ) : ?>
					<div class="desc"><?php echo $instance[ 'desc' ]; ?></div>
				<?php endif; ?>
				<!-- Address -->
				<?php if( !empty( $instance['address'] ) ) : ?>
					<div class="address"><i class="droplet-location-marker"></i><p><?php echo $instance[ 'address' ]; ?></p></div>
				<?php endif; ?>
				<!-- Phone -->
				<?php if( !empty( $instance['phone'] ) ) : ?>
					<div class="phone"><i class="droplet-headphone"></i><span><?php esc_html_e( 'Phone&nbsp;:&nbsp;&nbsp;', 'pixomi' ); ?></span><?php echo $instance[ 'phone' ]; ?></div>
				<?php endif; ?>
				<!-- Fax -->
				<?php if( !empty( $instance['fax'] ) ) : ?>
					<div class="fax"><i class="fa fa-fax"></i><span><?php esc_html_e( 'Fax&nbsp;:&nbsp;&nbsp;', 'pixomi' ); ?></span><?php echo $instance[ 'fax' ]; ?></div>
				<?php endif; ?>
				<!-- Email -->
				<?php if( !empty( $instance['email'] ) ) : ?>
					<div class="email"><i class="droplet-email"></i><span><?php esc_html_e( 'Email&nbsp;:&nbsp;&nbsp;', 'pixomi' ); ?></span><?php echo $instance[ 'email' ]; ?></div>
				<?php endif; ?>
				<!-- Website -->
				<?php if( !empty( $instance['web'] ) ) : ?>
					<div class="web"><i class="droplet-internet"></i><span><?php esc_html_e( 'Web&nbsp;:&nbsp;&nbsp;', 'pixomi' ); ?></span><?php echo $instance[ 'web' ]; ?></div>
				<?php endif; ?>

			</div>
			
			<?php echo $after_widget;
		}

		// Update Widget
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance[ 'title' ]	 = sanitize_text_field($new_instance[ 'title' ]);
			$instance[ 'desc' ]	     = sanitize_text_field($new_instance[ 'desc' ]);
			$instance[ 'address' ]	 = sanitize_text_field($new_instance[ 'address' ]);
			$instance[ 'phone' ]	 = sanitize_text_field($new_instance[ 'phone' ]);
			$instance[ 'fax' ]		 = sanitize_text_field($new_instance[ 'fax' ]);
			$instance[ 'email' ]	 = sanitize_email($new_instance[ 'email' ]);
			$instance[ 'web' ]		 = esc_url($new_instance[ 'web' ]);

			return $instance;
		}

		// Widget Form
		function form( $instance ) {
			$defaults	 = array(
				'title'		 => esc_html__('Contact Info','pixomi'),
				'desc'	     => '',
				'address'	 => '',
				'phone'		 => '',
				'fax'		 => '',
				'email'		 => '',
				'web'		 => '',
			);
			
			$instance	 = wp_parse_args( (array) $instance, $defaults ); ?>
			
			<!-- Title -->
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
			</p>
			<!-- Desc -->
			<p>
				<label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php esc_html_e( 'Description :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>" value="<?php echo $instance[ 'desc' ]; ?>" />
			</p>
			<!-- Address -->
			<p>
				<label for="<?php echo $this->get_field_id( 'address' ); ?>"><?php esc_html_e( 'Address :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" value="<?php echo $instance[ 'address' ]; ?>" />
			</p>
			<!-- Phone -->
			<p>
				<label for="<?php echo $this->get_field_id( 'phone' ); ?>"><?php esc_html_e( 'Phone Number :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" value="<?php echo $instance[ 'phone' ]; ?>" />
			</p>
			<!-- Fax -->
			<p>
				<label for="<?php echo $this->get_field_id( 'fax' ); ?>"><?php esc_html_e( 'Fax :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" value="<?php echo $instance[ 'fax' ]; ?>" />
			</p>
			<!-- Email -->
			<p>
				<label for="<?php echo $this->get_field_id( 'email' ); ?>"><?php esc_html_e( 'Email :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" value="<?php echo $instance[ 'email' ]; ?>" />
			</p>
			<!-- Website -->
			<p>
				<label for="<?php echo $this->get_field_id( 'web' ); ?>"><?php esc_html_e( 'Website Url :', 'pixomi' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'web' ); ?>" name="<?php echo $this->get_field_name( 'web' ); ?>" value="<?php echo $instance[ 'web' ]; ?>" />
			</p>

			<?php
		}

	}
}

