<?php

add_filter( 'cmb_meta_boxes', 'pixomi_page_metaboxes' );
function pixomi_page_metaboxes( array $meta_boxes ) {

	$prefix = 'pixomi_';

	/* =========================================================== */
	/* 00. Page Layout 
	/* =========================================================== */
	$meta_boxes[] = array(
		'id'         => 'pixomi_page_layout',
		'title'      => esc_html__('Page Layout', 'pixomi'),
		'pages'      => array( 'page' ),
		'context'    => 'side',
		'priority'   => 'default',
		'show_names' => true, 
		'fields'     => array(
			
			// Page Layout			   
			array(
				'name'    => esc_html__( 'Select Page Layout', 'pixomi' ),
				'id'      => $prefix . 'page_layout',
				'type'    => 'select',
				'options' => array(
					'default' 		=> esc_html__( 'Page : Default No Sidebar', 'pixomi' ),
					'right-sidebar' => esc_html__( 'Page : Right Sidebar', 'pixomi' ),
					'left-sidebar'  => esc_html__( 'Page : Left Sidebar', 'pixomi' ),
					'fullwidth'     => esc_html__( 'Page : FullWidth', 'pixomi' ),
				),
				
				'default'  => 'default',				
			),
		),
	);
	
	/* =========================================================== */
	/* 00. Portfolio Layout 
	/* =========================================================== */
	$meta_boxes[] = array(
		'id'         => 'pixomi_portfolio_layout',
		'title'      => esc_html__('Portfolio Page Layout', 'pixomi'),
		'pages'      => array( 'portfolio' ),
		'context'    => 'side',
		'priority'   => 'default',
		'show_names' => true, 
		'fields'     => array(
			
			// Portfolio Layout			   
			array(
				'name'    => esc_html__( 'Select Portfolio Page Layout', 'pixomi' ),
				'id'      => $prefix . 'portfolio_layout',
				'type'    => 'select',
				'options' => array(
					'default' 		=> esc_html__( 'Portfolio : Default No Sidebar', 'pixomi' ),
					'right-sidebar' => esc_html__( 'Portfolio : Right Sidebar', 'pixomi' ),
					'left-sidebar'  => esc_html__( 'Portfolio : Left Sidebar', 'pixomi' ),
					'fullwidth'     => esc_html__( 'Portfolio : FullWidth', 'pixomi' ),
				),
				
				'default'  => 'default',				
			),
		),
	);
	
	/* =========================================================== */
	/* 00. Slider Options 
	/* =========================================================== */
	$meta_boxes[] = array(
		'id'         => 'pixomi_page_slider_options',
		'title'      => esc_html__('Page Settings', 'pixomi'),
		'pages'      => array( 'page' ),
		'context'    => 'normal',
		'priority'   => 'default',
		'show_names' => true, 
		'fields'     => array(
			
			// Headers
			array(
				'name' 	=> esc_html__( 'Header Settings', 'pixomi' ),
				'id'   	=> $prefix . 'header_meta_info',
				'type' 	=> 'title',
			),
			
			// Header Layout
			array(
				'name'    => esc_html__( 'Header Layout', 'pixomi' ),
				'desc' 	  => esc_html__( 'Select Your Desired Header Layout You can view Header Layout from Admin Panel in Header Section.', 'pixomi' ),
				'id'      => $prefix . 'header_layout',
				'type'    => 'select',
				'options' => array(
					''    => esc_html__( 'Inherit From Theme Options', 'pixomi' ),
					'1'   => esc_html__( 'Header v1 Classic', 'pixomi' ),
					'2'   => esc_html__( 'Header v2 Modern', 'pixomi' ),
					'3'   => esc_html__( 'Header v3 Transparent', 'pixomi' ),
					'4'   => esc_html__( 'Header v4 Magzine Style', 'pixomi' ),
					'5'   => esc_html__( 'Header v5 Stack Modern', 'pixomi' ),
					'6'   => esc_html__( 'Header v6 Stack Logo Center', 'pixomi' ),
					'7'   => esc_html__( 'Header v7 Left Sidebar', 'pixomi' ),
				),
				'default'  => '',				
			),

			// Page Slider
			array(
				'name' 	=> esc_html__( 'Page Slider', 'pixomi' ),
				'id'   	=> $prefix . 'page_slider_info',
				'type' 	=> 'title',
			),

			// Page Banner
			array(
				'name'    => esc_html__( 'Enable page Slider', 'pixomi' ),
				'id'      => $prefix . 'enable_slider',
				'type'    => 'select',
				'options' => array(
					'' 		 => esc_html__( 'No', 'pixomi' ),
					'yes'    => esc_html__( 'Yes', 'pixomi' ),
				),
				
				'default'  => '',				
			),

			// Revolution Slider
			array(
				'name'    => esc_html__( 'Choose Revolution Slider', 'pixomi' ),
				'id'      => $prefix . 'rev_slider_type',
				'type'    => 'select',
				'options' => pixomi_get_rev_sliders(),
				'desc'    => esc_html__( 'Only Accessible When Page Slider is Yes.', 'pixomi' ),
				'default'  => '',				
			),
		),
	);

	/* =========================================================== */
	/* 00. Titlebar Options 
	/* =========================================================== */
	$meta_boxes[] = array(
		'id'         => 'pixomi_page_titlebar_options',
		'title'      => esc_html__('Page Titlebar Settings', 'pixomi'),
		'pages'      => array( 'page', 'portfolio', 'product' ),
		'context'    => 'normal',
		'priority'   => 'default',
		'show_names' => true, 
		'fields'     => array(
			
			// Page Slider
			array(
				'name' 	=> esc_html__( 'Page Titlebar ', 'pixomi' ),
				'id'   	=> $prefix . 'page_titlebar_info',
				'type' 	=> 'title',
			),

			// Titlebar
			array(
				'name'    => esc_html__( 'Enable Titlebar', 'pixomi' ),
				'id'      => $prefix . 'enable_titlebar',
				'type'    => 'select',
				'options' => array(
					'yes'    => esc_html__( 'Yes', 'pixomi' ),
					'no'     => esc_html__( 'No', 'pixomi' ),
				),
				
				'default'  => 'yes',				
			),

			// Titlebar Bg Image
			array(
				'name' 	  => esc_html__( 'Titlebar Background Image', 'pixomi' ),
				'desc' 	  => esc_html__( 'Choose Your Desired Background Image Instead of Default Image', 'pixomi' ),
			    'id' 	  => $prefix . 'titlebar_bg_img',
			    'type' 	  => 'file',
			    'default' => get_template_directory_uri().'/images/bg.jpg',
			),
		),
	);
		
	return $meta_boxes;
}
