<?php 

/* =========================================================== */
/* 00. Get Current Page ID 
/* =========================================================== */
function pixomi_current_page_id(){
    global $post, $wp_query;
    $current_page_id = '';
    // Get Page ID
    if($current_page_id == '') {
        if ( is_home () && is_front_page () ) {
            $current_page_id = '';
        } elseif ( is_home () ) {
            $current_page_id = get_option ( 'page_for_posts' );
        } elseif ( is_search () || is_category () || is_tag () || is_tax () ) {
            $current_page_id = '';
        } elseif ( !is_404 () ) {
           $current_page_id = $post->ID;
        }
    }
    // Get WooCommerce ID
    if(class_exists("woocommerce")) {
        if( is_shop() ){ 
            $current_page_id  =  get_option ( 'woocommerce_shop_page_id' );
        }elseif(is_cart()) {
            $current_page_id  =  get_option ( 'woocommerce_cart_page_id' );
        }elseif(is_checkout()){
            $current_page_id  =  get_option ( 'woocommerce_checkout_page_id' );
        }elseif(is_account_page()){
            $current_page_id  =  get_option ( 'woocommerce_myaccount_page_id' );
        }elseif(is_view_order_page()){
            $current_page_id  = get_option ( 'woocommerce_view_order_page_id' );
        }
    }
    return $current_page_id;
}

/* =========================================================== */
/* 00. Pagination 
/* =========================================================== */
if ( !function_exists( 'pixomi_pagination' ) ) {
    function pixomi_pagination( $before = '', $after = '' ) {
        global $wpdb, $wp_query;
        $request        = $wp_query->request;
        $posts_per_page = intval( get_query_var( 'posts_per_page' ) );
        $paged          = intval( get_query_var( 'paged' ) );
        $numposts       = $wp_query->found_posts;
        $max_page       = $wp_query->max_num_pages;
        if ( $numposts <= $posts_per_page ) {
            return;
        }
        if ( empty( $paged ) || $paged == 0 ) {
            $paged = 1;
        }
        $pages_to_show         = 5;
        $pages_to_show_minus_1 = $pages_to_show - 1;
        $half_page_start       = floor( $pages_to_show_minus_1 / 2 );
        $half_page_end         = ceil( $pages_to_show_minus_1 / 2 );
        $start_page            = $paged - $half_page_start;
        if ( $start_page <= 0 ) {
            $start_page = 1;
        }
        $end_page = $paged + $half_page_end;
        if ( ($end_page - $start_page) != $pages_to_show_minus_1 ) {
            $end_page = $start_page + $pages_to_show_minus_1;
        }
        if ( $end_page > $max_page ) {
            $start_page = $max_page - $pages_to_show_minus_1;
            $end_page   = $max_page;
        }
        if ( $start_page <= 0 ) {
            $start_page = 1;
        }

        echo $before . '<div class="pagination"><ul class="">' . "";
        if ( $paged > 1 ) {
            echo '<li class="first"><a href="' . get_pagenum_link() . '" title="' . esc_attr__( 'First', 'pixomi' ) . '"></a></li>';
        }

        $prevposts = get_previous_posts_link( '' );
        if ( $prevposts ) {
            echo '<li class="previous">' . $prevposts . '</li>';
        } else {
            echo '<li class="previous disabled"><a href="javascript:void(0)"></a></li>';
        }

        for ( $i = $start_page; $i <= $end_page; $i++ ) {
            if ( $i == $paged ) {
                echo '<li class="active"><a href="javascript:void(0)"><span>' . $i . '</span></a></li>';
            } else {
                echo '<li><a href="' . get_pagenum_link( $i ) . '"><span>' . $i . '</span></a></li>';
            }
        }
        echo '<li class="next">';
        next_posts_link( '' );
        echo '</li>';
        if ( $end_page < $max_page ) {
            echo '<li class="last"><a href="' . get_pagenum_link( $max_page ) . '" title="' . esc_attr__( 'Last', 'pixomi' ) . '"></a></li>';
        }
        echo '</ul></div>' . $after . "";
    }
}

/* =========================================================== */
/* 00. Page Title 
/* =========================================================== */
if ( !function_exists( 'pixomi_page_title' ) ) {
    function pixomi_page_title() {
        
        global $post, $pixomi_data;
        $id = pixomi_current_page_id();

        $title = '';
        $title = get_the_title( $id );
        $blog_page_id = get_option( 'page_for_posts' );
        // Get Home page
        if ( is_home() ) {
           $title = esc_html__( 'Blog', 'pixomi' );
        }
        // Get Single Post
        if ( is_singular( 'post' ) ) {
            $title = get_the_title(); 
        }
        // Get Search Page
        if ( is_search() ) {
            $title = esc_html__( 'Search Results For', 'pixomi' ) . '&nbsp;: ' . get_search_query(); 
        }
        // Get Error 404
        if ( is_404() ) {
            $title = esc_html__( 'Page Not Found', 'pixomi' ); 
        }
        // Get Archive pages
        if ( is_archive() ) {
            if ( is_day() ) {
                $title = esc_html_e( 'Daily Archives', 'pixomi' ) . ': ' . get_the_date();
            } else if ( is_month() ) {
                $title = esc_html_e( 'Monthly Archives', 'pixomi' ) . ': ' . get_the_date( _x( 'F Y', 'Monthly Archives', 'pixomi' ) );
            } elseif ( is_year() ) {
                $title = esc_html_e( 'Yearly Archives', 'pixomi' ) . ': ' . get_the_date( _x( 'Y', 'Yearly Archives', 'pixomi' ) );
            } elseif ( is_author() ) {
                $curauth = ( isset( $_GET[ 'author_name' ] ) ) ? get_user_by( 'slug', $_GET[ 'author_name' ] ) : get_user_by( 'id', get_the_author_meta( 'ID' ) );
                $title   = esc_html( $curauth->nickname );
            } else {
                $title = esc_html( single_cat_title( '', false ) );
            }
        }
        // Get Woo Shop
        if ( class_exists( 'Woocommerce' ) && is_woocommerce() && ( is_product() || is_shop() ) && !is_search() ) {
            if ( !is_product() ) {
                $title = esc_html__( 'Shop', 'pixomi' );
            }
        }
      return $title;
    }
}

/* =========================================================== */
/* 00. Header Icons 
/* =========================================================== */
// Woo Cart Icon
if (class_exists('Woocommerce')) {
    function pixomi_header_woo_cart_icon( $items, $args ) {
    global $pixomi_data;
    $switch_header_cart = $pixomi_data['switch_header_cart'];
    if($switch_header_cart){
        if ( $args->theme_location == 'pixomi-primary_menu' ) {
            global $woocommerce;
            $cart_link = function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : $woocommerce->cart->get_cart_url();
            $items .= '<li class="mini_cart_wrapper">
                          <a class="cart_count" href="' . $cart_link . '">
                            <i class="fa fa-shopping-cart"></i>
                            <span class="count">' . esc_html($woocommerce->cart->cart_contents_count) . '</span>
                          </a>
                      </li>';
       }
    }
        return $items;
    }
    add_filter( 'wp_nav_menu_items', 'pixomi_header_woo_cart_icon', 10, 2 );
}

// Search Icon
function pixomi_header_minisearch_icon( $items, $args ) {
    global $pixomi_data;
    $switch_header_search = $pixomi_data['switch_header_search'];
    if($switch_header_search){
        if( $args->theme_location == 'pixomi-primary_menu' ) {
            $items .= '<li class="menu-item minisearch">
                           <a href="javascript:void(0)" class="minisearch-btn"></a>
                           <div class="minisearch-wrap">
                               <form role="search" method="get" class="minisearch-form" action="' . esc_url( home_url( '/' ) ) . '">
                                    <input type="search" class="minisearch-input" name="s" value="' . get_search_query() . '" placeholder="' . esc_html__( "Search..", "pixomi" ) . '"/>
                                    <button type="submit" class="minisearch-btn"></button>
                               </form>
                           </div>
                       </li>';
        }
    }
        return $items;
}
add_filter('wp_nav_menu_items', 'pixomi_header_minisearch_icon', 10, 2);

/* =========================================================== */
/* 00. Blog Excerpt Length 
/* =========================================================== */
function pixomi_excerpt_length( $length ) {
    return 50;
}
add_filter( 'excerpt_length', 'pixomi_excerpt_length', 999 );

function pixomi_custom_excerpt( $limit = 50 ) {
  return wp_trim_words( get_the_content(), $limit, '.<a class="read-more" href="'. get_permalink() .'">' . esc_html__('Read More', 'pixomi') . '</a>');
}

/* =========================================================== */
/* 00. Body Class 
/* =========================================================== */
function pixomi_vertical_header_body_class( $classes ) {
    global $pixomi_data;
    $header_layout  = pixomi_choose_header();
    $header_left    = array(7);
    if ( in_array( $header_layout, $header_left )) {
        $classes[] = 'vertical-header-left';
    }
    return $classes;
}
add_filter( 'body_class', 'pixomi_vertical_header_body_class' );

/* =========================================================== */
/* 00. Choose Header 
/* =========================================================== */
function pixomi_choose_header(){

    global $post, $pixomi_data;
    $id = pixomi_current_page_id();
    $header = get_post_meta ( $id, 'pixomi_header_layout', true ) ? get_post_meta ( $id, 'pixomi_header_layout', true ) : '';
    if(!$header){
        $header = isset($pixomi_data["header_layout"]) ? $pixomi_data["header_layout"]: "1";
    } 
    return $header; 
}

/* =========================================================== */
/* 00. Comment Form Fields 
/* =========================================================== */
function pixomi_modify_comment_form_fields( $fields ) {
    $commenter = wp_get_current_commenter();
    $req       = get_option( 'require_name_email' );

    $fields[ 'author' ] = '<div class="row">'
    . '<div class="col-md-4 col-xs-12">'
    . '<div class="form-group">'
    . '<input type="text" class="comment-author" name="author" id="author" value="' . esc_attr( $commenter[ 'comment_author' ] ) . '" placeholder="' . esc_html__( "Name*", "pixomi" ) . '" size="22" ' . ( $req ? 'aria-required="true"' : '' ) . ' />'
    . '</div>'
    . '</div>';

    $fields[ 'email' ] = '<div class="col-md-4 col-xs-12">'
    . '<div class="form-group">'
    . '<input type="text" class="comment-email" name="email" id="email"  value="' . esc_attr( $commenter[ 'comment_author_email' ] ) . '" placeholder="' . esc_html__( "Email*", "pixomi" ) . '" size="22" ' . ( $req ? 'aria-required="true"' : '' ) . ' />'
    . '</div>'
    . '</div>';

    $fields[ 'url' ] = '<div class="col-md-4 col-xs-12">'
    . '<div class="form-group">'
    . '<input type="text" class="comment-url" name="url" id="url" value="' . esc_attr( $commenter[ 'comment_author_url' ] ) . '" placeholder="' . esc_html__( "Website", "pixomi" ) . '" size="22" />'
    . '</div>'
    . '</div>'
    . '</div>';

    return $fields;
}
add_filter( 'comment_form_default_fields', 'pixomi_modify_comment_form_fields' );

/* =========================================================== */
/* 00. Breadcrumbs 
/* =========================================================== */
if ( !function_exists( 'pixomi_breadcrumbs' ) ) {
    function pixomi_breadcrumbs() {

            $showOnHome  = 'yes';                              
            $delimiter   = esc_html__('&raquo;', 'pixomi');              
            $delimiter   = '<span class="delimiter">' . $delimiter . '</span>';
            $home        = esc_html__( 'Home', 'pixomi' );               
            $showCurrent = 'yes';
            $before      = '<span class="current">';
            $after       = '</span>';

            global $post;
            $homeLink       = home_url();
            $queried_object = get_queried_object();

            if ( is_home() || is_front_page() ) {
                if ( $showOnHome == 'yes' ) {
                    echo '<div class="breadcrumbs"><a href="' . $homeLink . '">' . $home . '</a></div>';
                }
            } else {
                echo '<div class="breadcrumbs"><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';

                if ( class_exists( 'Woocommerce' ) && is_woocommerce() && ( is_product() || is_shop() ) && !is_search() ) {
                    woocommerce_breadcrumb( $args = array() );
                } elseif ( class_exists( 'bbPress' ) && (is_bbpress()) ) {
                    echo bbp_breadcrumb();
                } elseif ( is_archive() ) {

                    if ( is_search() ) {
                        echo $before . esc_html__( 'Search results for:', 'pixomi' ) . get_search_query() . $after;
                    } elseif ( is_category() ) {
                        // Category
                        $thisCat = get_category( get_query_var( 'cat' ), false );
                        if ( $thisCat->parent != 0 ) {
                            echo get_category_parents( $thisCat->parent, TRUE, ' ' . $delimiter . ' ' );
                        }
                        echo $before . esc_html( single_cat_title( '', false ) ) . $after;
                    } elseif ( is_day() ) {
                        // Day
                        echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_date( 'Y' ) . '</a> ' . $delimiter . ' ';
                        echo '<a href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '">' . get_the_date( 'F' ) . '</a> ' . $delimiter . ' ';
                        echo $before . get_the_date( 'd' ) . $after;
                    } elseif ( is_month() ) {
                        // Month
                        echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_date( 'Y' ) . '</a> ' . $delimiter . ' ';
                        echo $before . get_the_date( 'F' ) . $after;
                    } elseif ( is_year() ) {
                        // Year
                        echo $before . get_the_date( 'Y' ) . $after;
                    } elseif ( is_tag() ) {
                        echo $before . 'Tag "' . esc_html( single_tag_title( '', false ) ) . '"' . $after;
                    } elseif ( is_author() ) {
                        global $author;
                        $userdata = get_userdata( $author );
                        echo $before . 'Author "' . esc_html( $userdata->display_name ) . '"' . $after;
                    } else {
                        echo $before . single_cat_title( '', false ) . $after;
                    }
                } elseif ( is_single() && !is_attachment() ) {
                    if ( get_post_type() == 'pixomi-portfolio' ) {
                        $post_type = get_post_type_object( get_post_type() );
                        $terms     = get_the_terms( $post->ID, 'pixomi-portfolio-category' );
                        if ( $terms ) {
                            $cat = $terms[ 0 ];
                            echo '<a href="' . get_term_link( $cat ) . '">' . $cat->name . '</a>';
                            if ( $showCurrent == 'yes' ) {
                                echo ' ' . $delimiter . ' ';
                            }
                        }
                        if ( $showCurrent == 'yes' ) {
                            echo $before . get_the_title() . $after;
                        }
                    } elseif ( get_post_type() == 'post' ) {
                        $cat  = get_the_category();
                        $cat  = $cat[ 0 ];
                        $cats = get_category_parents( $cat, TRUE, ' ' . $delimiter . ' ' );
                        if ( $showCurrent == 'no' )
                            $cats = preg_replace( "#^(.+)\s$delimiter\s$#", "$1", $cats );
                        echo $cats;
                        if ( $showCurrent == 'yes' ) {
                            echo $before . esc_html( get_the_title() ) . $after;
                        }
                    } else {
                        $post_type = get_post_type_object( get_post_type() );
                        echo '<a href="' . get_post_type_archive_link( get_post_type() ) . '">' . $post_type->labels->singular_name . '</a>';
                        if ( $showCurrent == 'yes' ) {
                            echo ' ' . $delimiter . ' ' . $before . esc_html( get_the_title() ) . $after;
                        }
                    }
                } elseif ( is_attachment() ) {
                    $parent_id = $post->post_parent;
                    if ( $parent_id ) {
                        echo '<a href="' . get_permalink( $parent_id ) . '">' . get_the_title( $parent_id ) . '</a>';
                        if ( $showCurrent == 'yes' ) {
                            echo ' ' . $delimiter . ' ';
                        }
                    }
                    if ( $showCurrent == 'yes' ) {
                        echo $before . get_the_title() . $after;
                    }
                } elseif ( is_page() && !$post->post_parent ) {
                    if ( $showCurrent == 'yes' ) {
                        echo $before . get_the_title() . $after;
                    }
                } elseif ( is_page() && $post->post_parent ) {
                    $parent_id   = $post->post_parent;
                    $breadcrumbs = array();
                    while ( $parent_id ) {
                        $page          = get_page( $parent_id );
                        $breadcrumbs[] = '<a href="' . get_permalink( $page ) . '">' . esc_html( get_the_title( $page ) ) . '</a>';
                        $parent_id     = $page->post_parent;
                    }
                    $breadcrumbs = array_reverse( $breadcrumbs );
                    for ( $i = 0; $i < count( $breadcrumbs ); $i++ ) {
                        echo $breadcrumbs[ $i ];
                        if ( $i != count( $breadcrumbs ) - 1 )
                            echo ' ' . $delimiter . ' ';
                    }
                    if ( $showCurrent == 'yes' )
                        echo ' ' . $delimiter . ' ' . $before . esc_html( get_the_title() ) . $after;
                } elseif ( is_404() ) {
                    echo $before . esc_html__( 'Error 404', 'pixomi' ) . $after;
                }

                echo '</div>';
            }
    }
}

/* =========================================================== */
/* 00. Theme Slider 
/* =========================================================== */
function pixomi_page_banner(){
    
    global $post, $pixomi_data;
    $enable_slider = get_post_meta( $post->ID, 'pixomi_enable_slider', true );
    
    // Slider Wrapper
    if($enable_slider){
        echo "<div class='pixomi-slider'>";
        if( $enable_slider == 'yes' ){
            if(shortcode_exists('rev_slider') || function_exists('rev_slider')){
                $rev_slider = get_post_meta( $post->ID, 'pixomi_rev_slider_type', true );
                if($rev_slider){
                    echo do_shortcode('[rev_slider "'. $rev_slider .'"]');
                }
            }
        }
       echo "</div>";
    }
}

// Get Rev Slider List
function pixomi_get_rev_sliders(){
    $rev_sliders = array ();
    if ( class_exists ( "RevSlider" ) ) {
        $revSlider = new RevSlider();
        $sliders = $revSlider->getArrSliders ();
        if ( $sliders ) {
            foreach ( $sliders as $slider ) {
                $rev_sliders[ $slider->getAlias() ] = $slider->getTitle();
            }
        }
    }
    return $rev_sliders;
}

/* =========================================================== */
/* 00. Remove Revslider Metabox 
/* =========================================================== */
if ( is_admin() ) {
    function pixomi_remove_rev_slider_meta_boxes() {
        remove_meta_box( 'mymetabox_revslider_0', 'page', 'normal' );
        remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
        remove_meta_box( 'mymetabox_revslider_0', 'product', 'normal' );
        remove_meta_box( 'mymetabox_revslider_0', 'portfolio', 'normal' );
    }
    add_action( 'do_meta_boxes', 'pixomi_remove_rev_slider_meta_boxes' );
}

/* =========================================================== */
/* 00. Demo Importer 
/* =========================================================== */
// Description
if ( !function_exists( 'pixomi_wbc_importer_description_text' ) ) {
    function pixomi_wbc_importer_description_text( $description ) {

        $message = '<p class="redux-notice-field">'. esc_html__( 'Importing Demo data ( Post, Pages, Images, Theme Settings.. ) is the Easiest way to setup your Theme. It will allow you to Quickly edit everything instead of Creating Content from Scratch. When you import the data Following Things will Happen 1. No existing posts, pages, categories, images, custom post types or any other data will be deleted or modified 2. No WordPress settings will be modified 3. Posts, pages, some images, some widgets and menus will get imported 4. Images will be downloaded from our server, these images are copyrighted and are for demo use only 5. Please click on import Demo Button Once and Please Be Patient it can take a Couple of Minutes Depend on Your Server Speed. Before you Begin, make sure all the Required and Recommended Theme Plugins are Activated.', 'pixomi' ) .'</p>';
        return $message;
    }
    add_filter( 'wbc_importer_description', 'pixomi_wbc_importer_description_text', 10 );
}

/* =========================================================== */
/* 00. Theme Extras 
/* =========================================================== */
// Category Widget Archive Count
function pixomi_cat_count_span($links) {
    $links = str_replace('</a> (', ' (', $links);
    $links = str_replace(')', ')</a>', $links);
    return $links;
}
add_filter('wp_list_categories', 'pixomi_cat_count_span');

// Archive Widget Post Count
function pixomi_archive_count_span($links) {
    $links = str_replace('</a>&nbsp;(', ' (', $links);
    $links = str_replace(')', ')</a>', $links);
    return $links;
}
add_filter('get_archives_link', 'pixomi_archive_count_span');
