<?php

function pixomi_dynamic_styles() {
    global $pixomi_data;

    // Theme Colors
    $primary_color                   = $pixomi_data['primary_color']; 

    // Header Topbar 
    $topbar_bg_color                 = $pixomi_data['topbar_bg_color']; 
    $topbar_text_color               = $pixomi_data['topbar_text_color']; 
    $topbar_info_icons_color         = $pixomi_data['topbar_info_icons_color']; 
    $topbar_social_icons_color       = $pixomi_data['topbar_social_icons_color']; 
    $topbar_navigation_color         = $pixomi_data['topbar_navigation_color']; 
    $topbar_nav_hover_color          = $pixomi_data['topbar_nav_hover_color']; 
    $topbar_button_bg_color          = $pixomi_data['topbar_button_bg_color']; 
    $topbar_button_bg_hover_color    = $pixomi_data['topbar_button_bg_hover_color']; 
    $topbar_button_text_color        = $pixomi_data['topbar_button_text_color'];
    
    // Header Fonts 
    $nav_font_family                 = $pixomi_data['nav_fonts']['font-family'];
    $nav_font_weight                 = $pixomi_data['nav_fonts']['font-weight'];
    $nav_text_transform              = $pixomi_data['nav_fonts']['text-transform'];
    $nav_font_size                   = $pixomi_data['nav_fonts']['font-size'];

    // Header Fonts 
    $subnav_font_family              = $pixomi_data['subnav_fonts']['font-family'];
    $subnav_font_weight              = $pixomi_data['subnav_fonts']['font-weight'];
    $subnav_text_transform           = $pixomi_data['subnav_fonts']['text-transform'];
    $subnav_font_size                = $pixomi_data['subnav_fonts']['font-size'];

    // Header v1 & v2 
    $header12_bg_color               = $pixomi_data['header12_bg_color'];
    $header12_link_color             = $pixomi_data['header12_link_color'];
    $header12_link_hover_color       = $pixomi_data['header12_link_hover_color'];
    $header12_link_active_color      = $pixomi_data['header12_link_active_color'];

    // Header v3 
    $header3_bg_color                = $pixomi_data['header3_bg_color'];
    $header3_link_color              = $pixomi_data['header3_link_color'];
    $header3_link_hover_color        = $pixomi_data['header3_link_hover_color'];
    $header3_link_active_color       = $pixomi_data['header3_link_active_color'];

    // Header v4,v5,v6  
    $header456_bg_color              = $pixomi_data['header456_bg_color'];
    $header456_link_color            = $pixomi_data['header456_link_color'];
    $header456_link_hover_color      = $pixomi_data['header456_link_hover_color'];
    $header456_link_active_color     = $pixomi_data['header456_link_active_color'];

    // Vertical Header  
    $vh_link_color                    = $pixomi_data['vh_link_color'];
    $vh_link_hover_color              = $pixomi_data['vh_link_hover_color'];
    $vh_link_active_color             = $pixomi_data['vh_link_active_color'];

    // Headers info styling 
    $header45_info_icon_color        = $pixomi_data['header45_info_icon_color'];
    $header45_info_color             = $pixomi_data['header45_info_color'];

    // Sub Nav 
    $subnav_background_color         = $pixomi_data['subnav_background_color'];
    $subnav_link_color               = $pixomi_data['subnav_link_color'];
    $subnav_link_hover_color         = $pixomi_data['subnav_link_hover_color'];
    $subnav_link_active_color        = $pixomi_data['subnav_link_active_color'];

    // Mobile Nav 
    $mobile_nav_bg_color             = $pixomi_data['mobile_nav_bg_color'];
    $mobile_nav_link_color           = $pixomi_data['mobile_nav_link_color'];
    $mobile_nav_link_ha_color        = $pixomi_data['mobile_nav_link_ha_color'];

    // Titlebar 
    $titlebar_top_padding            = $pixomi_data['titlebar_top_padding'];
    $titlebar_bottom_padding         = $pixomi_data['titlebar_bottom_padding'];
    $titlebar_title_size             = $pixomi_data['titlebar_title_size'];
    $titlebar_title_color            = $pixomi_data['titlebar_title_color'];
    $breadcrumb_txt_color            = $pixomi_data['breadcrumb_txt_color'];
    $breadcrumb_link_color           = $pixomi_data['breadcrumb_Current_link_color'];

    // Body Fonts
    $body_font_family                = $pixomi_data['body_fonts']['font-family'];
    $body_font_weight                = $pixomi_data['body_fonts']['font-weight'];
    $body_font_size                  = $pixomi_data['body_fonts']['font-size'];
    $body_line_height                = $pixomi_data['body_fonts']['line-height'];
    $body_font_color                 = $pixomi_data['body_fonts']['color'];

    // Headign Fonts
    $headings_font_family            = $pixomi_data['headings_fonts']['font-family'];
    $headings_font_weight            = $pixomi_data['headings_fonts']['font-weight'];
    $headings_text_transform         = $pixomi_data['headings_fonts']['text-transform'];
    $headings_line_height            = $pixomi_data['headings_fonts']['line-height'];
    $headings_letter_spacing         = $pixomi_data['headings_fonts']['letter-spacing'];
    $headings_font_color             = $pixomi_data['headings_fonts']['color'];

    // Footer Widget Area 
    $widget_area_bg_color              = $pixomi_data['widget_area_bg_color']; 
    $widget_area_heading_color         = $pixomi_data['widget_area_heading_color']; 
    $widget_area_text_color            = $pixomi_data['widget_area_text_color']; 
    $widget_area_link_color            = $pixomi_data['widget_area_link_color']; 
    $widget_area_border_color          = $pixomi_data['widget_area_border_color']; 
    $widget_area_social_icons_color    = $pixomi_data['widget_area_social_icons_color']; 
    $widget_area_social_icons_bg_color = $pixomi_data['widget_area_social_icons_bg_color']; 
    
    // Footer Copyright Area
    $copyright_bg_color                = $pixomi_data['copyright_bg_color']; 
    $copyright_text_color              = $pixomi_data['copyright_text_color']; 
    $copyright_nav_color               = $pixomi_data['copyright_nav_color']; 
    $copyright_nav_hover_color         = $pixomi_data['copyright_nav_hover_color']; 
    $copyright_top_border_color        = $pixomi_data['copyright_top_border_color']; 

    // Testimonail Fonts
    $testimonial_font_family           = $pixomi_data['testimonial_fonts']['font-family'];
    $testimonial_font_weight           = $pixomi_data['testimonial_fonts']['font-weight'];
    $testimonial_font_size             = $pixomi_data['testimonial_fonts']['font-size'];
    $testimonial_font_height           = $pixomi_data['testimonial_fonts']['line-height'];
    $testimonial_font_style            = $pixomi_data['testimonial_fonts']['font-style'];
    $testimonial_font_color            = $pixomi_data['testimonial_fonts']['color']; 

    // Special Fonts
    $special_font_family               = $pixomi_data['special_fonts']['font-family'];
    $special_font_weight               = $pixomi_data['special_fonts']['font-weight'];

    $pixomi_custom_dynamic_styles = '
    
    /* Header Topbar */ 
    #topbar { background-color: '. esc_attr($topbar_bg_color) .'; }
    #topbar { color: '. esc_attr($topbar_text_color) .' !important; }
    #topbar i{ color: '. esc_attr($topbar_info_icons_color) .' !important; }
    #topbar .topbar-social span a i,
    #topbar .topbar-social span a i:hover{ color: '. esc_attr($topbar_social_icons_color) .' !important; }
    #topbar a,
    #topbar ul.menu li a { color: '. esc_attr($topbar_navigation_color) .' !important; }
    #topbar ul.menu li a:hover { color: '. esc_attr($topbar_nav_hover_color) .' !important; }
    #topbar ul.menu li a:hover { border-top-color: '. esc_attr($topbar_nav_hover_color) .' !important; }
    #topbar .topbar-button a { background-color: '. esc_attr($topbar_button_bg_color) .' !important; }
    #topbar .topbar-button a:hover { background-color: '. esc_attr($topbar_button_bg_hover_color) .' !important; }
    #topbar .topbar-button a,
    #topbar .topbar-button a:hover { color: '. esc_attr($topbar_button_text_color) .' !important; }

    /* Navigation Fonts */
    #navigation ul li a{
      font-family: '. esc_attr($nav_font_family) .' !important;
      font-weight: '. esc_attr($nav_font_weight) .' !important;
      text-transform: '. esc_attr($nav_text_transform) .' !important;
      font-size: '. esc_attr($nav_font_size) .' !important;
    }

    /* Sub Nav Fonts */
    #navigation .sub-menu li a{
      font-family: '. esc_attr($subnav_font_family) .' !important;
      font-weight: '. esc_attr($subnav_font_weight) .' !important;
      text-transform: '. esc_attr($subnav_text_transform) .' !important;
      font-size: '. esc_attr($subnav_font_size) .' !important;
    }

    /* Header v1 and v2 */
    #header.header-v1, #header.header-v2 .container { background-color: '. esc_attr($header12_bg_color) .'; }
    #header.header-v1 #navigation > ul > li > a, #header.header-v2 #navigation > ul > li > a { color: '. esc_attr($header12_link_color) .'; }
    #header.header-v1 #navigation > ul > li > a:hover, 
    #header.header-v2 #navigation > ul > li > a:hover, 
    #header.header-v1 #navigation > ul > li > a:focus, 
    #header.header-v2 #navigation > ul > li > a:focus, 
    #header.header-v1 #navigation > ul > li.sfHover > a, 
    #header.header-v2 #navigation > ul > li.sfHover > a,
    #header.header-v1 #navigation > ul > li.current-page-ancestor > a:hover, 
    #header.header-v2 #navigation > ul > li.current-page-ancestor > a:hover,
    #header.header-v1 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v2 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v1 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v2 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v1 #navigation > ul > li.current_page_ancestor > a:hover, 
    #header.header-v2 #navigation > ul > li.current_page_ancestor > a:hover {
      color: '. esc_attr($header12_link_hover_color) .' !important; }

    #header.header-v1 #navigation > ul > li > a:active, 
    #header.header-v2 #navigation > ul > li > a:active, 
    #header.header-v1 #navigation > ul > li.current-menu-item > a, 
    #header.header-v2 #navigation > ul > li.current-menu-item > a, 
    #header.header-v1 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v2 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v1 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v2 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v1 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v2 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v1 #navigation > ul > li.current_page_ancestor > a,
    #header.header-v2 #navigation > ul > li.current_page_ancestor > a {
      color: '. esc_attr($header12_link_active_color) .' !important; }

    /* Header v3 */
    #header.header-v3 #navigation > ul > li > a { color: '. esc_attr($header3_link_color) .'; }

    #header.header-v3 #navigation > ul > li > a:hover, 
    #header.header-v3 #navigation > ul > li > a:focus, 
    #header.header-v3 #navigation > ul > li.sfHover > a, 
    #header.header-v3 #navigation > ul > li.current-page-ancestor > a:hover, 
    #header.header-v3 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v3 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v3 #navigation > ul > li.current_page_ancestor > a:hover{ 
      color: '. esc_attr($header3_link_hover_color) .' !important; }

    #header.header-v3 #navigation > ul > li > a:active, 
    #header.header-v3 #navigation > ul > li.current-menu-item > a, 
    #header.header-v3 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v3 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v3 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v3 #navigation > ul > li.current_page_ancestor > a {
      color: '. esc_attr($header3_link_active_color) .' !important;  
   }

    /* Header v4, v5 and v6 */
    #header.header-v4 .nav-block, 
    #header.header-v5 .nav-block .container, 
    #header.header-v6 .nav-block { background-color: '. esc_attr($header456_bg_color) .'; }
    
    #header.header-v4 #navigation > ul > li > a, 
    #header.header-v5 #navigation > ul > li > a, 
    #header.header-v6 #navigation > ul > li > a { color: '. esc_attr($header456_link_color) .'; }

    #header.header-v4 #navigation > ul > li > a:hover, 
    #header.header-v5 #navigation > ul > li > a:hover, 
    #header.header-v6 #navigation > ul > li > a:hover, 
    #header.header-v4 #navigation > ul > li > a:focus, 
    #header.header-v5 #navigation > ul > li > a:focus, 
    #header.header-v6 #navigation > ul > li > a:focus, 
    #header.header-v4 #navigation > ul > li.sfHover > a, 
    #header.header-v5 #navigation > ul > li.sfHover > a,
    #header.header-v6 #navigation > ul > li.sfHover > a,
    #header.header-v4 #navigation > ul > li.current-page-ancestor > a:hover, 
    #header.header-v5 #navigation > ul > li.current-page-ancestor > a:hover,
    #header.header-v6 #navigation > ul > li.current-page-ancestor > a:hover,
    #header.header-v4 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v5 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v6 #navigation > ul > li.current-menu-ancestor > a:hover, 
    #header.header-v4 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v5 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v6 #navigation > ul > li.current-menu-parent > a:hover, 
    #header.header-v4 #navigation > ul > li.current_page_ancestor > a:hover, 
    #header.header-v5 #navigation > ul > li.current_page_ancestor > a:hover,
    #header.header-v6 #navigation > ul > li.current_page_ancestor > a:hover {
      color: '. esc_attr($header456_link_hover_color) .' !important; }

    #header.header-v4 #navigation > ul > li > a:active, 
    #header.header-v5 #navigation > ul > li > a:active, 
    #header.header-v6 #navigation > ul > li > a:active, 
    #header.header-v4 #navigation > ul > li.current-menu-item > a, 
    #header.header-v5 #navigation > ul > li.current-menu-item > a, 
    #header.header-v6 #navigation > ul > li.current-menu-item > a, 
    #header.header-v4 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v5 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v6 #navigation > ul > li.current-page-ancestor > a, 
    #header.header-v4 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v5 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v6 #navigation > ul > li.current-menu-ancestor > a, 
    #header.header-v4 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v5 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v6 #navigation > ul > li.current-menu-parent > a, 
    #header.header-v4 #navigation > ul > li.current_page_ancestor > a,
    #header.header-v5 #navigation > ul > li.current_page_ancestor > a,
    #header.header-v6 #navigation > ul > li.current_page_ancestor > a {
      color: '. esc_attr($header456_link_active_color) .' !important; }

    /* Vertical Header */
    .vh-social span a i,
    .header-v7 #navigation > ul > li > a { color: '. esc_attr($vh_link_color) .'; }

    .vh-social span a i:hover,
    .header-v7 #navigation > ul > li > a:hover, 
    .header-v7 #navigation > ul > li > a:focus, 
    .header-v7 #navigation > ul > li.sfHover > a, 
    .header-v7 #navigation > ul > li.current-page-ancestor > a:hover, 
    .header-v7 #navigation > ul > li.current-menu-ancestor > a:hover, 
    .header-v7 #navigation > ul > li.current-menu-parent > a:hover, 
    .header-v7 #navigation > ul > li.current_page_ancestor > a:hover{ 
      color: '. esc_attr($vh_link_hover_color) .' !important; }

    .header-v7 #navigation > ul > li > a:active, 
    .header-v7 #navigation > ul > li.current-menu-item > a, 
    .header-v7 #navigation > ul > li.current-page-ancestor > a, 
    .header-v7 #navigation > ul > li.current-menu-ancestor > a, 
    .header-v7 #navigation > ul > li.current-menu-parent > a, 
    .header-v7 #navigation > ul > li.current_page_ancestor > a {
      color: '. esc_attr($vh_link_active_color) .' !important;  
   }

    /* Headers Info Styling */
    #header.header-v4 .info-box-icon,
    #header.header-v5 .info-box-icon { color: '. esc_attr($header45_info_icon_color) .' !important; }

    #header.header-v4 .info-box-content h6, 
    #header.header-v5 .info-box-content h6, 
    #header.header-v4 .info-box-content p,
    #header.header-v5 .info-box-content p { color: '. esc_attr($header45_info_color) .' !important; }

    /* Sub Navigation */
    #header #navigation .sub-menu { background-color: '. esc_attr($subnav_background_color) .' !important; }
    #header #navigation .sub-menu li a { color: '. esc_attr($subnav_link_color) .' !important; }
    #header #navigation .sub-menu li a:hover { color: '. esc_attr($subnav_link_hover_color) .' !important; }
    #header #navigation .sub-menu li.current-menu-item > a,
    #header #navigation .sub-menu li.current-menu-item > a:hover,
    #header #navigation .sub-menu li.current-page-ancestor > a,
    #header #navigation .sub-menu li.current-page-ancestor > a:hover,
    #header #navigation .sub-menu li.current-menu-ancestor > a,
    #header #navigation .sub-menu li.current-menu-ancestor > a:hover,
    #header #navigation .sub-menu li.current-menu-parent > a,
    #header #navigation .sub-menu li.current-menu-parent > a:hover,
    #header #navigation .sub-menu li.current_page_ancestor > a,
    #header #navigation .sub-menu li.current_page_ancestor > a:hover {
     color: '. esc_attr($subnav_link_active_color) .' !important; 
    }

    /* Mobile Navigation */
    #mobile-navigation { background-color: '. esc_attr($mobile_nav_bg_color) .'; }
    #mobile-navigation ul li a, #mobile-navigation ul li a:hover { color: '. esc_attr($mobile_nav_link_color) .'; }
    #mobile-navigation ul li a:hover, 
    #mobile-navigation ul li a:hover [class^="fa-"], 
    #mobile-navigation li.open > a, 
    #mobile-navigation ul li.current-menu-item > a, 
    #mobile-navigation ul li.current-menu-ancestor > a { 
        color: '. esc_attr($mobile_nav_link_ha_color) .'; 
    }

    /* Titlebar */
    #titlebar h1 { font-size: '. esc_attr($titlebar_title_size) .'; padding-top: '. esc_attr($titlebar_top_padding) .' !important; padding-bottom: '. esc_attr($titlebar_bottom_padding) .' !important; }
    #titlebar h1 { color: '. esc_attr($titlebar_title_color) .'; }
    .breadcrumbs span, .breadcrumbs a { color: '. esc_attr($breadcrumb_link_color) .'; }

    /* Body Fonts */
    body{
      font-family: '. esc_attr($body_font_family) .' !important;
      font-weight: '. esc_attr($body_font_weight) .' !important;
      font-size: '. esc_attr($body_font_size) .' !important;
      line-height: '. esc_attr($body_line_height) .' !important;
      color: '. esc_attr($body_font_color) .' !important;
    }

    /* Testimonial Fonts */
    .testimonial-box p, .testimonial-slider .testimonial p{
      font-family: '. esc_attr($testimonial_font_family) .' !important;
      font-weight: '. esc_attr($testimonial_font_weight) .' !important;
      font-size: '. esc_attr($testimonial_font_size) .' !important;
      line-height: '. esc_attr($testimonial_font_height) .' !important;
      font-style: '. esc_attr($testimonial_font_style) .' !important;
      color: '. esc_attr($testimonial_font_color) .' !important;
    }

    /* Special Fonts */
    button,
    input[type="button"],
    input[type="reset"],
    input[type="submit"],
    .slider-btn,
    .pagination ul > li.previous > a,
    .pagination ul > li.next > a,
    #error-content .content-inner h1,
    .search-page .post .entry-type span,
    .search-page .search-content .read-more a,
    a.landing-btn,
    .blog-classic .read-more a,
    .blog-list .read-more a,
    .imgbox-style-1 .imgbox-btn a,
    .imgbox-style-2 .imgbox-btn a,
    .counter h4,
    .button, 
    .woocommerce a.button,
    .tm-style-1 .tm-btn a,
    .tm-style-2 .tm-btn a,
    .iconbox-btn a {
      font-family: '. esc_attr($special_font_family) .' !important;
      font-weight: '. esc_attr($special_font_weight) .' !important;
    }

    .wpb_single_image .vc_figure-caption,
    .mont, span.mont, p.mont {
      font-family: '. esc_attr($special_font_family) .' !important;
    }

    /* General Font Color */
    p a:hover, p a:focus, label, select { color: '. esc_attr($body_font_color)  .'; }

    /* Extras Font Color */
    .comment-body p, .commentmetadata a, 
    .blog-author .author-bio .author-desc,
    .single-post-tags a, 
    .social-share .share i, 
    #sidebar .search-form .search-submit, 
    #sidebar .widget ul li a, 
    .widget_recent_comments ul li, 
    .widget_recent_comments ul li:before,
    .widget_recent_entries ul li:before, 
    .widget_recent_entries ul li a, 
    .contact-widget .contact-info div,
    .contact-widget .contact-info i, 
    body .widget .tagcloud a, 
    .newsletter-inner, #sidebar .widget p,
    blockquote:before, blockquote, 
    .dropcap.simple::first-letter, 
    .entry-summary .price .amount, table, 
    .blog-classic .entry-meta ul li a,
    .blog-list .entry-meta ul li a, 
    .blog-single .entry-meta ul li a, 
    .blog-list .entry-meta ul li a,
    .portfolio-style .portfolio-category,
    .portfolio-filters span a, 
    .blog-single .entry-meta ul li a
    { color: '. esc_attr($body_font_color) .'; }

    /* WooCommerce Font Color */
    .widget_price_filter .price_slider_amount, 
    .widget_product_categories ul li a, 
    .widget.woocommerce .price ins,
    .widget.woocommerce ul li span.amount, 
    .widget.woocommerce ul li del span.amount, 
    .widget.woocommerce ins span.amount,
    .widget.woocommerce ins, span.price del span.amount, 
    .woocommerce ul li del .amount, .widget.woocommerce.widget_shopping_cart ul li span.quantity,
    .widget.woocommerce.widget_products ul li span.quantity, 
    .widget.woocommerce.widget_recently_viewed_products ul li span.quantity
    { color: '. esc_attr($body_font_color)  .' !important; }

    /* Theme Headings Color */
    p a:hover, p a:focus, 
    .comment.list li cite, 
    .comment-body a, 
    .blog-author .author-bio .author-name, 
    .widget_product_categories h3, 
    .widget h3, #sidebar .widget h3,
     #footer .woo-col-widget .widget h3,
    strong, b, .page-numbers, 
    table.shop_table .order-total th,
    table.shop_table .order-total td, 
    table.shop_table th, 
    div table.shop_table td,
    .cart_totals.calculated_shipping table td .amount, 
    .vc_tta-container .vc_tta.vc_general.vc_tta-accordion.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-heading .vc_tta-panel-title a,
    .wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a,
    .vc_toggle_title h4, .vc_pie_chart .vc_pie_chart_value, 
    .vc_progress_bar .vc_single_bar .vc_label,
    .vc_progress_bar .wpb_heading, 
    .widget_nav_menu ul li a:hover,
    #sidebar .widget_nav_menu ul li a,
    .widget.widget_rss h2 a,
    #sidebar .widget_pages > ul > li > a,  
    .widget_pages ul li a:hover { color: '. esc_attr($headings_font_color) .' !important; }
    .widget h2 { color: '. esc_attr($headings_font_color) .'; }

    /* Headings Fonts */
    h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a{
      font-family: '. esc_attr($headings_font_family) .';
      font-weight: '. esc_attr($headings_font_weight) .';
      text-transform: '. esc_attr($headings_text_transform) .';
      line-height: '. esc_attr($headings_line_height) .';
      letter-spacing: '. esc_attr($headings_letter_spacing) .';
      color: '. esc_attr($headings_font_color) .';
    }

    /* Footer Widget Area */
    #footer .widget-area { background-color: '. esc_attr($widget_area_bg_color) .'; }
    #footer .widget-area .widget h2 { color: '. esc_attr($widget_area_heading_color) .' !important; }
    #footer .widget-area p, 
    .widget_recent_entries .post-date, 
    #footer .image-post-widget .widget-post-date, 
    .mc4wp-form label, 
    #footer strong { color: '. esc_attr($widget_area_text_color) .' !important; }
    #footer .widget ul li a, 
    #footer a, 
    #footer .widget .tagcloud a { color: '. esc_attr($widget_area_link_color) .'; }
    #footer .widget .tagcloud a { border-color: '. esc_attr($widget_area_link_color) .'; }

    #footer .widget ul li a:hover, 
    #footer .widget-area .widget ul li, 
    #footer .widget_categories > ul > li > a, 
    #footer .widget_meta ul li a, 
    #footer .widget_rss ul li a,
    #footer .widget_archive > ul > li > a, 
    #footer .form-login ul li a, 
    #footer #wp-calendar td, 
    #footer #wp-calendar th,
    #footer .widget.widget_nav_menu ul li, 
    #footer .widget.widget_pages ul li,
    #footer .widget_recent_entries ul li,
    #footer .widget_pages > ul > li > ul > li > a,
    #footer .widget_pages > ul > li > ul > li > ul > li > a
    { border-bottom-color: '. esc_attr($widget_area_border_color) .'; }

    /* Footer Widgets */
    #footer .contact-widget .contact-info .desc:after { background-color: '. esc_attr($widget_area_border_color) .'; color: '. esc_attr($widget_area_link_color) .'; }
    #footer .widget_tag_cloud a, 
    #footer .widget_product_tag_cloud a { border-color: '. esc_attr($widget_area_border_color) .'; color: '. esc_attr($widget_area_link_color) .'; }
        
    #footer .widget_search input[type="search"], 
    #footer .newsletter-inner input[type="email"] #footer #calendar_wrap th,td, 
    #footer #wp-calendar caption, 
    #footer .widget .tagcloud a, 
    #footer .form-login input
    { border-color: '. esc_attr($widget_area_border_color)  .'; }
    
    #footer #wp-calendar td, 
    #footer .widget_search .search-submit, 
    #footer .newsletter-inner,
    #footer .contact-widget .contact-info div, 
    #footer .widget_recent_comments ul li, 
    #footer .widget_recent_comments li:before, 
    #footer .widget_recent_entries ul li:before, 
    #footer .form-login label,
    #footer .widget_rss .rss-date,
    #footer .widget_rss .rssSummary,
    #footer .widget_rss cite
    { color: '. esc_attr($widget_area_text_color) .'; }
     
    #footer .social-widget span a { color: '. esc_attr($widget_area_social_icons_color) .'; }
    #footer .social-widget span a, #footer #wp-calendar caption { background-color: '. esc_attr($widget_area_social_icons_bg_color) .' !important; }

    /* Footer Copyright Area */
    #footer .copyright { background-color: '. esc_attr($copyright_bg_color)  .'; }
    #footer .copyright-text, #footer .copyright a { color: '. esc_attr($copyright_text_color) .'; }
    #footer .copyright-nav ul.menu li a { color: '. esc_attr($copyright_nav_color) .'; }
    #footer .copyright-nav ul.menu li a:hover { color: '. esc_attr($copyright_nav_hover_color) .' !important; }
    #footer .copyright { border-top-color: '. esc_attr($copyright_top_border_color) .'; }

    /* Primary Color : General*/
    a, a:hover, a:focus, p a, p a:hover { color: '. esc_attr($primary_color) .'; }
    p a { color: '. esc_attr($primary_color) .'; }
    .accent { color: '. esc_attr($primary_color) .'; }
    .accent-bg { color: '. esc_attr($primary_color) .'; }
    ::selection { background-color: '. esc_attr($primary_color) .'; }
    ::-moz-selection { background-color: '. esc_attr($primary_color) .'; }
    
    input[type="text"]:focus,
    input[type="password"]:focus,
    input[type="email"]:focus,
    input[type="number"]:focus,
    input[type="search"]:focus,
    input[type="tel"]:focus,
    input[type="date"]:focus,
    input[type="url"]:focus,
    textarea:focus { 
        border-color: '. esc_attr($primary_color) .'; 
        color: '. esc_attr($body_font_color) .'; 
    }

    button, 
    input[type="button"], 
    input[type="reset"], 
    input[type="submit"] {
        background-color: '. esc_attr($primary_color) .'; 
    }

    /* Accent Color : Footer */
    #footer .widget_tag_cloud a:hover, 
    #footer .widget_product_tag_cloud a:hover, 
    #footer #wp-calendar tbody td:hover, 
    #footer .copyright-social span a i:hover, 
    body .widget .tagcloud a:hover, 
    #footer .form-login input[type="submit"],
    .headline-seperator span, 
    .widget.widget_mc4wp_form_widget form.mc4wp-form .droplet_footer_newsletter label,
    #sidebar .social-widget span a,
    .widget h2:before,
    #footer .widget .tagcloud a:hover 
    { background-color: '. esc_attr($primary_color) .'; }
    #wp-calendar td#today, 
    .widget .tagcloud a:hover { background-color: '. esc_attr($primary_color) .' !important; }
    .rev_slider .wpcf7 { border-top-color: '. esc_attr($primary_color) .' !important; }

    /* Accent Color : Widgets */
    #sidebar .widget ul li a:hover, 
    #footer .widget ul li a:hover, 
    .contact-widget .contact-info i, 
    #footer .copyright a:hover, 
    .widget_categories ul li a:before,
    .widget_meta li a:before,
    .widget_rss li a:before,
    .widget_archive ul li a:before, 
    #footer .copyright i,
    #footer .widget.widget_nav_menu ul li a:before, 
    #footer .widget.widget_pages ul li a:before,
    #footer .copyright-nav ul.menu li a:hover,
    .image-post-widget .widget-post-date:before, 
    .widget_product_categories ul li a::before,
    #footer .widget_pages > ul > li > ul > li > a:before,
    #footer .widget_search .search-submit,
    .rev_slider .form-info strong,
    #footer .widget_pages > ul > li > ul > li > ul > li > a:before
    { color: '. esc_attr($primary_color) .' !important; }

    .widget.widget_nav_menu ul li:hover > a, 
    .widget.widget_pages ul li:hover > a,
    .widget.widget_nav_menu ul li.current-menu-item > a, 
    .widget.widget_nav_menu ul li.current_page_item > a, 
    .widget.widget_nav_menu ul li.current-cat > a, 
    .widget.widget_pages ul li.current-menu-item > a, 
    .widget.widget_pages ul li.current_page_item > a, 
    .widget.widget_pages ul li.current-cat > a,
    .widget.widget_nav_menu ul li.current-menu-item:hover > a, 
    .widget.widget_nav_menu ul li.current_page_item:hover > a, 
    .widget.widget_nav_menu ul li.current-cat:hover > a, 
    .widget.widget_pages ul li.current-menu-item:hover > a, 
    .widget.widget_pages ul li.current_page_item:hover > a, 
    .widget.widget_pages ul li.current-cat:hover > a
    { border-left-color: '. esc_attr($primary_color) .' !important; }

    /* Accent Color : Shortcodes */
    .vc_tta-container .vc_tta.vc_general.vc_tta-accordion.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-heading,
    .wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a,
    .vc_toggle.vc_toggle_default.vc_toggle_active .vc_toggle_title, 
    .heading-seperator, 
    #footer .social-widget span a:hover,
    .iconbox i.fa, 
    .slider-btn.light,
    .slider-btn.dark:hover,
    .counter h4:after,
    .brochure-btn a,
    .counter h2:after
    { background-color: '. esc_attr($primary_color) .'; }

    .cta-style-2 .btn { background-color: '. esc_attr($primary_color) .'; }

    .cta-style-1, .cta-style-2, 
    .iconbox-btn a,
    .imgbox-style-1 .imgbox-btn a,
    .imgbox-style-2 .imgbox-btn a { background-color: '. esc_attr($primary_color) .'; }
    .slick-dots li.slick-active button:before { color: '. esc_attr($primary_color) .'; }
    
    .recent-posts .post span i, 
    .counter i, .btn-outline, 
    .list-shortcode ul li:before,
    .tm-style-1 .person-caption i, 
    .tm-style-2 .person-caption i  { color: '. esc_attr($primary_color) .'; }
    
    .btn, .btn-square, .btn-round, 
    .btn-rounded, #sidebar .contact-box, 
    .tm-style-2 .social-icons li i:hover,
    .tm-style-1 .social-icons li i:hover, 
    .tm-style-2 .tm-btn a,
    .tm-style-1 .tm-btn a { background-color: '. esc_attr($primary_color) .'; }
    
    .btn-outline, #sidebar .contact-box { border-color: '. esc_attr($primary_color) .'; }

    /* Accent Color : Blog */
    .blog-classic .post h2 a:hover, 
    .blog-list .post h2 a:hover,   
    .blog-classic .post .entry-title h2 span,
    .blog-classic .entry-meta ul li i, 
    .blog-list .entry-meta ul li i,
    .blog-list .read-more a,
    .blog-list .read-more a:after,
    .blog-single .entry-meta ul li i,
    .breadcrumbs .current
     { color: '. esc_attr($primary_color) .'; }

    .blog-classic .read-more a, 
    .search-page .search-content .read-more a, 
    .woocommerce-tabs ul.tabs li.active a, .products .onsale,
    .products .onsale:before, 
    .products .onsale:after,
    .blog-classic article.sticky .sticky-lable,
    .blog-list article.sticky .sticky-lable,
    .sticky-lable:before,
    .sticky-lable:after{ background-color: '. esc_attr($primary_color) .'; }
    
    /* Accent Color : WooCommerce */
    .ui-slider .ui-slider-handle:before, 
    .products .button.add_to_cart_button,
    .added_to_cart.wc-forward, 
    .entry-summary .button.single_add_to_cart_button,
    .checkout-button, 
    #reviews .stars a, 
    #header li.woo_mini_cart > a > strong,
    .woocommerce-account .woocommerce-MyAccount-navigation ul li a,
    a.cart_count span.count  
    { background-color: '. esc_attr($primary_color) .'; }

    .summary .product_meta span.sku_wrapper:before, 
    .summary .product_meta span.posted_in:before,
    .summary .product_meta span.tagged_as:before  
    { color: '. esc_attr($primary_color) .'; }

     /* Accent Color : Pagination */
    .pagination ul > li span:hover, 
    .pagination ul > li span:focus, 
    .pagination ul > li.active > a span, 
    .pagination ul > li.active > a:hover span, 
    .pagination ul > li.previous > a:hover, 
    .pagination ul > li.next > a:hover, 
    .pagination ul > li.first > a:hover, 
    .pagination ul > li.last > a:hover  
    { background-color: '. esc_attr($primary_color) .'; }
    
    /* Accent Color : Extras */
    .comment.list .reply a, 
    #cancel-comment-reply-link, .back-to-top:hover { background-color: '. esc_attr($primary_color) .'; }
    .comment-body, 
    blockquote { border-left-color: '. esc_attr($primary_color) .'; }
    .comment-awaiting-moderation, 
    blockquote cite, 
    span.highlight, 
    .highlight { color: '. esc_attr($primary_color) .' !important; }

    /* Accent Color : Titlebar */
    .single-crumbs .breadcrumbs span, .single-crumbs .breadcrumbs a { color: '. esc_attr($primary_color) .'; }

    /* Accent Color : Post Types */
    .portfolio-filters span a.active { background-color: '. esc_attr($primary_color) .'; }
    .portfolio-style-1 h3 a:hover,
    .portfolio-style-2-content h3 a:hover 
    { color: '. esc_attr($primary_color) .'; }

    ';

    wp_add_inline_style( 'pixomi-stylesheet', $pixomi_custom_dynamic_styles );
}

add_action( 'wp_enqueue_scripts', 'pixomi_dynamic_styles' );
