<?php

/* =========================================================== */
/* 00. Theme Options Config
/* =========================================================== */
if ( ! class_exists( 'ReduxFramework' ) ) {
    return;
}

$opt_name = "pixomi_data";
$theme = wp_get_theme(); 
$args = array(
    'opt_name'          => 'pixomi_data',
    'disable_tracking'  => true,        
    'display_name'      => $theme->get('Name'),   
    'display_version'   => $theme->get('Version'),  
    'menu_type'         => 'submenu',                  
    'allow_sub_menu'    => false,                    
    'menu_title'        => esc_html__('Theme Options', 'pixomi'),
    'page_title'        => esc_html__('Theme Options', 'pixomi'),
    'save_defaults'     => true,
    'async_typography'  => true,
    'admin_bar'         => false, 
    'global_variable'   => 'pixomi_data',  
    'dev_mode'          => false, 
    'customizer'        => false,  
    'page_slug'         => 'pixomi_options',
    'system_info'       => false,
    'use_cdn'           => false,
    'show_import_export'  => true,
    'show_options_object' => false,
    'disable_save_warn' => true,
    'footer_credit'     => '&nbsp;',
);
Redux::setArgs( $opt_name, $args );


/* =========================================================== */
/* 00. General 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('General', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'fields'    => array(

        array(
            'id'        => 'favicon_info',
            'type'      => 'info',
            'desc' => esc_html__('You can Add Favicon on you site By Simply go to Apperance > Customize Click on Site Identity and Click on Select Image Button. You Favicon Size Should be 512x512px', 'pixomi'),
        ),

        // Theme Logo
        array(
            'id'       => 'theme_logo',
            'type'     => 'media',
            'preview'  => true,
            'url'      => false,
            'title'    => esc_html__('Theme Logo', 'pixomi'),
            'default'  => array(
                'url'  => get_template_directory_uri().'/images/logo.png',
            ),
        ),

        // Transparent Logo
        array(
            'id'       => 'light_logo',
            'type'     => 'media',
            'preview'  => true,
            'url'      => false,
            'title'    => esc_html__('Light Logo', 'pixomi'),
            'desc'     => esc_html__('Upload Light Logo for Transparent Header Header v3', 'pixomi'),
            'default'  => array(
                'url'  => get_template_directory_uri().'/images/light-logo.png',
            ),
        ),
     ),
) );


/* =========================================================== */
/* 00. Header Sections
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header', 'pixomi'),
        'icon'      => 'el-icon-website',
        'fields'    => array(
 
        ),
    ) );

/* =========================================================== */
/* 00. Topbar
/* =========================================================== */
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Topbar', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

            // Header Topbar Setting
            array(
                'id'        => 'topbar_settings',
                'type'      => 'info',
                'desc'      => esc_html__('Topbar Content Goes Here.', 'pixomi'),
            ),

            // Switch topbar
            array(
                'id'      =>'switch_topbar',
                'type'    => 'switch',
                'title'   => esc_html__('Enable Topbar', 'pixomi'),
                "default" => false,
            ), 

            // Topbar Left Content
            array(
                'id'       => 'topbar_left',
                'type'     => 'select',
                'title'    => esc_html__('Top Bar Left Content', 'pixomi'), 
                'desc'    => esc_html__('Choose Your Desired Topbar Left Content', 'pixomi'), 
                'options'  => array(
                    'topbar_contacts'=> esc_html__( 'Contact Info', 'pixomi' ),
                    'topbar_social'  => esc_html__( 'Social Icons', 'pixomi' ),
                    'topbar_nav'     => esc_html__( 'Navigation', 'pixomi' ),
                    'topbar_button'  => esc_html__( 'Button', 'pixomi' ),
                    'topbar_empty'   => esc_html__( 'Empty', 'pixomi' ),
                ),
                'default'  => 'topbar_contacts',
            ),

            // Topbar Right Content
            array(
                'id'       => 'topbar_right',
                'type'     => 'select',
                'title'    => esc_html__('Top Bar Right Content', 'pixomi'), 
                'desc'    => esc_html__('Choose Your Desired Topbar Right Content', 'pixomi'), 
                'options'  => array(
                    'topbar_contacts'=> esc_html__( 'Contact Info', 'pixomi' ),
                    'topbar_social'  => esc_html__( 'Social Icons', 'pixomi' ),
                    'topbar_nav'     => esc_html__( 'Navigation', 'pixomi' ),
                    'topbar_button'  => esc_html__( 'Button', 'pixomi' ),
                    'topbar_empty'   => esc_html__( 'Empty', 'pixomi' ),
                ),
                'default'  => 'topbar_nav',
            ),

            array(
                'id'        => 'topbar_contact_info',
                'type'      => 'info',
                'desc'      => esc_html__('Topbar Contact Info.', 'pixomi'),
            ),

            // Address Icon
            array(
                'id'      =>'topbar_address_icon',
                'type'     => 'text',
                'title'    => esc_html__('Address Icon', 'pixomi'),
                'desc'     => esc_html__('Enter Address Icon You can enter Font Awesome Icon class here http://fontawesome.io/icons/', 'pixomi'), 
                'default'  => esc_html__('droplet-location-marker', 'pixomi')
            ), 

            // Address
            array(
                'id'      =>'topbar_address',
                'type'     => 'text',
                'title'    => esc_html__('Address', 'pixomi'),
                'desc'     => esc_html__('If you Dont Want to Show Address Just Leave it Blank', 'pixomi'), 
                'default'  => esc_html__('848 E 28th St, Brooklyn NY, US', 'pixomi')
            ), 

            // Phone Icon
            array(
                'id'      =>'topbar_phone_icon',
                'type'     => 'text',
                'title'    => esc_html__('Phone Number Icon', 'pixomi'),
                'desc'     => esc_html__('Enter Phone Number Icon You can enter Font Awesome Icon class here http://fontawesome.io/icons/', 'pixomi'), 
                'default'  => esc_html__('droplet-old-telephone', 'pixomi')
            ), 

            // Phone
            array(
                'id'      =>'topbar_phone',
                'type'     => 'text',
                'title'    => esc_html__('Phone Number', 'pixomi'),
                'desc'     => esc_html__('If you Dont Want to Show Phone Number Just Leave it Blank', 'pixomi'), 
                'default'  => esc_html__('+1 724-452-9065', 'pixomi')
            ), 

            // Hour Icon
            array(
                'id'      =>'tobpar_working_hour_icon',
                'type'     => 'text',
                'title'    => esc_html__('Working Hours Icon', 'pixomi'),
                'desc'     => esc_html__('Enter Working Hours Icon You can enter Font Awesome Icon class here http://fontawesome.io/icons/', 'pixomi'), 
                'default'  => esc_html__('droplet-clock-circle', 'pixomi')
            ), 

            // Hour
            array(
                'id'      =>'tobpar_working_hour',
                'type'     => 'text',
                'title'    => esc_html__('Working Hours', 'pixomi'),
                'desc'     => esc_html__('If you Dont Want to Show Working Hours Just Leave it Blank', 'pixomi'), 
                'default'  => esc_html__(' Mon - Sat 8.00AM - 18.00PM', 'pixomi')
            ), 

            array(
                'id'        => 'topbar_btn',
                'type'      => 'info',
                'desc'      => esc_html__('Topbar Button.', 'pixomi'),
            ),

            // Button Text
            array(
                'id'      =>'topbar_button_text',
                'type'     => 'text',
                'title'    => esc_html__('Topbar Button Text', 'pixomi'),
                'default'  => esc_html__('Request A Quote', 'pixomi')
            ), 

            // Button Link
            array(
                'id'      =>'topbar_button_link',
                'type'     => 'text',
                'title'    => esc_html__('Topbar Button Link', 'pixomi'),
                'desc'     => esc_html__('Enter Topbar Button Link with http://', 'pixomi'),
            ),

            // Header Topbar Styling
            array(
                'id'        => 'header_topbar_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Topbar Styling.', 'pixomi'),
            ),
            
            array(
                'id'=>'topbar_bg_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#2c394c',
            ),
            
            array(
                'id'=>'topbar_text_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Text Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),
            
            array(
                'id'=>'topbar_info_icons_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Info Icons Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),
            
            array(
                'id'=>'topbar_social_icons_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Social Icons Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),

            array(
                'id'=>'topbar_navigation_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Navigation Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),

            array(
                'id'=>'topbar_nav_hover_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Navigation Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'topbar_button_bg_color',
                'type' => 'color',
                'title' => esc_html__('Tobpar Button Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'topbar_button_bg_hover_color',
                'type' => 'color',
                'title' => esc_html__('Topbar Button Background Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'topbar_button_text_color',
                'type' => 'color',
                'title' => esc_html__('Tobpar Button Text Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ), 
        ),
    ) );

/* =========================================================== */
/* 00. Header Layout
/* =========================================================== */
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Layout', 'pixomi'),
        'subsection'  => true,
        'icon'      => 'el-icon-cog',
        'fields'    => array(

            // Theme Headers
            array(
                'id'       => 'header_layout',
                'type'     => 'image_select',
                'title'    => esc_html__('Header Layout', 'pixomi'), 
                'subtitle' => esc_html__('Select Your Desired Header Layout', 'pixomi'),
                'options'  => array(
                    
                    '1'      => array(
                        'title'   => esc_html__('Header v1 Classic', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/1.png'
                    ),
                    
                    '2'      => array(
                        'title'   => esc_html__('Header v2 Modern', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/2.png'
                    ),

                    '3'      => array(
                        'title'   => esc_html__('Header v3 Transparent', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/3.png'
                    ),

                    '4'      => array(
                        'title'   => esc_html__('Header v4 Magzine Style', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/4.png'
                    ),

                    '5'      => array(
                        'title'   => esc_html__('Header v5 Stack Modern', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/5.png'
                    ),

                    '6'      => array(
                        'title'   => esc_html__('Header v6 Stack Logo Center', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/6.png'
                    ),

                    '7'      => array(
                        'title'   => esc_html__('Header v7 Left Sidebar', 'pixomi'), 
                        'img'   => get_template_directory_uri().'/images/headers/7.png'
                    ),
                ),
                'default' => '1'
            ),

            // Switch Header Search
            array(
                'id'      =>'switch_header_search',
                'type'    => 'switch',
                'title'   => esc_html__('Enable Header Search', 'pixomi'),
                "default" => true,
            ), 

            array(
                'id'        => 'header45_info_info',
                'type'      => 'info',
                'desc'      => esc_html__('Header v4 and v5 Info Goes Here.', 'pixomi'),
            ),

            array(
                'id'      =>'header_phone',
                'type'     => 'text',
                'title'    => esc_html__('Phone Number', 'pixomi'),
                'desc'     => esc_html__('If you Dont Want to Show Phone Number Just Leave it Blank.', 'pixomi'),
                'default'  => esc_html__('+1 724-452-9065', 'pixomi'),
            ),
            
            array(
                'id'      =>'header_email',
                'type'     => 'text',
                'title'    => esc_html__('Email', 'pixomi'),
                'desc'    => esc_html__('If you Dont Want to Show Email Just Leave it Blank.', 'pixomi'),
                'default'  => esc_html__('info@pixomi.com', 'pixomi'),
            ),
            
            array(
                'id'      =>'header_address',
                'type'     => 'text',
                'title'    => esc_html__('Address', 'pixomi'),
                'desc'    => esc_html__('If you Dont Want to Show Address Just Leave it Blank.', 'pixomi'),
                'default'  => esc_html__('848 E 28th St, Brooklyn NY, US', 'pixomi'),
            ),

            array(
                'id'        => 'header45_info_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Header v4 and v5 Info Styling Goes Here.', 'pixomi'),
            ),

            array(
                'title' => esc_html__('Header v4 & v5 Info Icon Color', 'pixomi'),
                'desc' => esc_html__('Choose Your Desired Header v4 & v5 Info Icon Color', 'pixomi'),
                'id'=>'header45_info_icon_color',
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'title' => esc_html__('Header v4 & v5 Info Color', 'pixomi'),
                'desc' => esc_html__('Choose Your Desired Header v4 & v5 Info Color ie Phone Number, Email and Address', 'pixomi'),
                'id'=>'header45_info_color',
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#002e5b',
            ),
        ),
    ) );


/* =========================================================== */
/* 00. Header Styling
/* =========================================================== */
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Styling', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

            // Header v1 and V2
            array(
                'id'        => 'header12_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Header v1 and v2 Styling.', 'pixomi'),
            ),
            
            array(
                'title' => esc_html__('Header Background Color', 'pixomi'),
                'id'=>'header12_bg_color',
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),
                    
            array(
                'id'=>'header12_link_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#002e5b',
            ),
            
            array(
                'id'=>'header12_link_hover_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'header12_link_active_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            // Header v3
            array(
                'id'        => 'header3_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Header v3 Styling.', 'pixomi'),
            ),
            
            array(         
                'title'    => esc_html__('Header Background Color', 'pixomi'),
                'desc'     => esc_html__('Choose Your Desired Header Background Color With Half Transparent', 'pixomi'),
                'id'       => 'header3_bg_color',
                'type'     => 'color_rgba',
                'default'   => array(
                    'color'     => '#FFFFFF',
                    'alpha'     => 0.6
                ),
                'output' => array(
                    'background-color' => '#header.header-v3'
                ),
            ),

            array(
                'id'=>'header3_link_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#2c394c',
            ),
            
            array(
                'id'=>'header3_link_hover_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'header3_link_active_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            // Header v4, v5 and v6
            array(
                'id'        => 'header456_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Header v4, v5 and v6 Styling.', 'pixomi'),
            ), 

            array(
                'title' => esc_html__('Header Background Color', 'pixomi'),
                'id'=>'header456_bg_color',
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#2c394c',
            ), 

            array(
                'id'=>'header456_link_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),
            
            array(
                'id'=>'header456_link_hover_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'header456_link_active_color',
                'type' => 'color',
                'title' => esc_html__('Header Link Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            // Header v7 vh Styling
            array(
                'id'        => 'vh_styling_info',
                'type'      => 'info',
                'desc'      => __('<strong>Header v7 Vertical Header</strong> Styling.', 'pixomi'),
            ),

            array(
                'id'       => 'vh_background',
                'type'     => 'background',
                'output'   => array('.header-v7'),
                'title'    => esc_html__('Vertical Header Background', 'pixomi'),
                'desc'     => esc_html__('Choose Vertical Header Background Color or Image.', 'pixomi'),
                'transparent' => false,
                'default'  => array(
                    'background-color' => '#fff',
                )
            ),

            array(
                'id'=>'vh_link_color',
                'type' => 'color',
                'title' => esc_html__('Vertical Header Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#002e5b',
            ),

            array(
                'id'=>'vh_link_hover_color',
                'type' => 'color',
                'title' => esc_html__('Vertical Header Link Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'vh_link_active_color',
                'type' => 'color',
                'title' => esc_html__('Vertical Header Link Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            // Navigation Submenu Styling
            array(
                'id'        => 'navigation_submenu_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Navigation Submenu Styling.', 'pixomi'),
            ),

            array(
                'id'=>'subnav_background_color',
                'type' => 'color',
                'title' => esc_html__('Sub Navigation Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),

            array(
                'id'=>'subnav_link_color',
                'type' => 'color',
                'title' => esc_html__('Sub Navigation Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#002e5b',
            ),

            array(
                'id'=>'subnav_link_hover_color',
                'type' => 'color',
                'title' => esc_html__('Sub Navigation Link Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'subnav_link_active_color',
                'type' => 'color',
                'title' => esc_html__('Subnavigation Link Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

        ),
    ) );

/* =========================================================== */
/* 00. Mobile Menu
/* =========================================================== */
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Mobile Menu', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

            // Mobile Menu Styling
            array(
                'id'        => 'mobile_menu_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Mobile Menu Styling.', 'pixomi'),
            ),

            array(
                'id'=>'mobile_nav_bg_color',
                'type' => 'color',
                'title' => esc_html__('Mobile Navigation Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#2c394c',
            ),

            array(
                'id'=>'mobile_nav_link_color',
                'type' => 'color',
                'title' => esc_html__('Mobile Navigation Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),

            array(
                'id'=>'mobile_nav_link_ha_color',
                'type' => 'color',
                'title' => esc_html__('Mobile Navigation Link Hover and Active Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),
        ),
    ) );

/* =========================================================== */
/* 00. Titlebar
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Titlebar', 'pixomi'),
        'icon'      => 'el-icon-text-width',
        'fields'    => array(

        // Title Styling
        array(
            'id'        => 'titlebar_stylig_info',
            'type'      => 'info',
            'desc'      => esc_html__('Titlebar Title Styling Goes Here.', 'pixomi'),
        ),

        array(
            'id'      =>'titlebar_top_padding',
            'type'     => 'text',
            'title'    => esc_html__('Titlebar Top Padding', 'pixomi'),
            'desc'     => esc_html__('Enter Titlebar Top Padding in px.', 'pixomi'),
            'default'  => esc_html__('70px', 'pixomi'),
        ),
        
        array(
            'id'      =>'titlebar_bottom_padding',
            'type'     => 'text',
            'title'    => esc_html__('Titlebar Bottom Padding', 'pixomi'),
            'desc'     => esc_html__('Enter Titlebar Bottom Padding in px.', 'pixomi'),
            'default'  => esc_html__('50px', 'pixomi'),
        ),

        array(
            'id'       =>'titlebar_title_size',
            'type'     => 'text',
            'title'    => esc_html__('Titlebar Title Size', 'pixomi'),
            'desc'     => esc_html__('Enter Titlebar Title Size in px.', 'pixomi'),
            'default'  => esc_html__('30px', 'pixomi'),
        ),

        // Title Color
        array(
            'id'=>'titlebar_title_color',
            'type' => 'color',
            'title' => esc_html__('Titlebar Title Color', 'pixomi'),
            'desc' => esc_html__('Select Titlebar Title Color.', 'pixomi'),
            'default' => '#002e5b',
            'transparent' => false,
            'validate' => 'color',
        ),

        // Bread Styling Info
        array(
            'id'        => 'bread_styling_info',
            'type'      => 'info',
            'desc'      => esc_html__('Breadcrumbs Styling Goes Here.', 'pixomi'),
        ),

        // Txt Color
        array(
            'id'=>'breadcrumb_txt_color',
            'type' => 'color',
            'title' => esc_html__('Breadcrumbs Text Color', 'pixomi'),
            'desc' => esc_html__('Choose Your Desired Breadcrumb Text Color.', 'pixomi'),
            'default' => '#002e5b',
            'transparent' => false,
            'validate' => 'color',
        ),

        // Link Color
        array(
            'id'=>'breadcrumb_Current_link_color',
            'type' => 'color',
            'title' => esc_html__('Breadcrumbs Current Link Color', 'pixomi'),
            'desc'  => esc_html__('Choose Your Desired Breadcrumb Current Link Color.', 'pixomi'),
            'default' => '#002e5b',
            'transparent' => false,
            'validate' => 'color',
        ),
        ),
    ) );


/* =========================================================== */
/* 00. Footer Sections
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Footer', 'pixomi'),
        'icon'      => 'el-icon-wrench',
        'fields'    => array(

        ),
    ) );

/* =========================================================== */
/* 00. Footer Widgets
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Footer Widgets', 'pixomi'),
        'icon'      => 'el-icon-wrench',
        'subsection'      => true,
        'fields'    => array(

            // Footer Widget Area Styling
            array(
                'id'        => 'widget_area_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Footer Widget Area Styling.', 'pixomi'),
            ),

            array(
                'id'        =>'widget_area_bg_color',
                'type'      => 'color',
                'title'     => esc_html__('Widget Area Background Color', 'pixomi'),
                'transparent' => false,
                'validate'  => 'color',
                'default'   => '#2c394c',
            ),

            array(
                'id'        =>'widget_area_heading_color',
                'type'      => 'color',
                'title'     => esc_html__('Widget Area Heading Color', 'pixomi'),
                'transparent' => false,
                'validate'  => 'color',
                'default'   => '#fff',
            ),

            array(
                'id'=>'widget_area_text_color',
                'type' => 'color',
                'title' => esc_html__('Widget Area Text Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#90a2bc',
            ),

            array(
                'id'=>'widget_area_link_color',
                'type' => 'color',
                'title' => esc_html__('Widget Area Link Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#90a2bc',
            ),
            
            array(
                'id'=>'widget_area_border_color',
                'type' => 'color',
                'title' => esc_html__('Widget Area Border Color', 'pixomi'),
                'transparent' => true,
                'validate' => 'color',
                'default' => '#465467',
            ),

            array(
                'id'=>'widget_area_social_icons_color',
                'type' => 'color',
                'title' => esc_html__('Widget Area Social Icons Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#fff',
            ),

            array(
                'id'=>'widget_area_social_icons_bg_color',
                'type' => 'color',
                'title' => esc_html__('Widget Area Social Icons Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#47576c',
            ),
        ),
    ) );

/* =========================================================== */
/* 00. Footer Copyright
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Footer Copyright', 'pixomi'),
        'icon'      => 'el-icon-wrench',
        'subsection'      => true,
        'fields'    => array(

            // Footer Copyright Setting
            array(
                'id'        => 'footer_copyright_setting_info',
                'type'      => 'info',
                'desc'      => esc_html__('Footer Copyright Setting', 'pixomi'),
            ),

            array(
                'id'       =>'copyright_text',
                'type'     => 'textarea',
                'rows'     => '3',
                'title'    => esc_html__('Copyright Text', 'pixomi'),
                'default'  => esc_html__('&copy; Copyright 2018 Theme Made With &hearts; By dropletthemes', 'pixomi'),
            ),

            // Footer Copyright Styling
            array(
                'id'        => 'footer_copyright_styling_info',
                'type'      => 'info',
                'desc'      => esc_html__('Footer Copyright Styling.', 'pixomi'),
            ),

            array(
                'id'=>'copyright_bg_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Background Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#2c394c',
            ),

            array(
                'id'=>'copyright_text_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Text Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#90a2bc',
            ),

            array(
                'id'=>'copyright_nav_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Navigation Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#90a2bc',
            ),

            array(
                'id'=>'copyright_nav_hover_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Navigation Hover Color', 'pixomi'),
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),

            array(
                'id'=>'copyright_top_border_color',
                'type' => 'color',
                'title' => esc_html__('Copyright Top Border Color', 'pixomi'),
                'transparent' => true,
                'validate' => 'color',
                'default' => '#465467',
            ),
        ),
    ) );

/* =========================================================== */
/* 00. Typography 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Typography', 'pixomi'),
        'icon'      => 'el-icon-link',
        'fields'    => array(        
    ),
) );


/* =========================================================== */
/* 00. Header Fonts 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header Fonts', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

        array(
            'id'        => 'header_typography_info',
            'type'      => 'info',
            'desc'      => esc_html__('Header Typography.', 'pixomi'),
        ),

        // Main Navigaiton
        array(
            'id'=>'nav_fonts',
            'type' => 'typography',
            'title' => esc_html__('Navigation Fonts', 'pixomi'),
            'desc'  => esc_html__('Select Your Desired Font Family for Navigation.', 'pixomi'),
            'subsets'=>false,
            'line-height'=>false,
            'text-transform'=>true,
            'letter-spacing'=>false,
            'text-align'=>false,
            'color'=>false,
            'default'=> array(
                'font-family'=>'Montserrat',
                'font-weight'=>'700',
                'text-transform'=>'uppercase',
                'font-size'=>'14px'
            )
        ),

        // Main Navigaiton
        array(
            'id'=>'subnav_fonts',
            'type' => 'typography',
            'title' => esc_html__('Sub Navigation Fonts', 'pixomi'),
            'desc'  => esc_html__('Select Your Desired Font Family for Sub Navigation.', 'pixomi'),
            'subsets'=>false,
            'line-height'=>false,
            'text-transform'=>true,
            'letter-spacing'=>false,
            'text-align'=>false,
            'color'=>false,
            'default'=> array(
                'font-family'=>'Montserrat',
                'font-weight'=>'700',
                'text-transform'=>'capitalize',
                'font-size'=>'15px'
            )
        ),
        ),
    ) );


/* =========================================================== */
/* 00. Body Fonts 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Body Fonts', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

        // Body Typography
        array(
            'id'        => 'body_typography_info',
            'type'      => 'info',
            'desc'      => esc_html__('Body Typography.', 'pixomi'),
        ),

        array(
            'id'       =>'body_fonts',
            'type'     => 'typography',
            'title'    => esc_html__('Body Fonts', 'pixomi'),
            'desc'    => esc_html__('This Body Typography Will be Applied on Body Content ie paragraphs, links etc.', 'pixomi'),
            'units'          => 'px',
            'google'         => true,
            'subsets'        => false,
            'text-transform' => false,
            'letter-spacing' => false,
            'font-style'     => true,
            'font-weight'    => true,
            'color'          => true,
            'text-align'     => false,
            'font-family'    => true,
            'all_styles'     => true,
            'default'     => array(
                'font-family' => 'Poppins',
                'font-weight' => '400',
                'font-size' => '14px',
                'line-height' => '25px',
                'color' => '#637281'
            )
        ),

        // Headings Typography
        array(
            'id'        => 'headings_typography_info',
            'type'      => 'info',
            'desc'      => esc_html__('Theme Headings Typography.', 'pixomi'),
        ),

        array(
            'id'       =>'headings_fonts',
            'type'     => 'typography',
            'title'    => esc_html__('Headings Fonts', 'pixomi'),
            'desc'    => esc_html__('This Heading Fonts Will be Applied on H1, H2, H3, H4, H5, H6.', 'pixomi'),
            'subsets'        => false,
            'text-transform' => true,
            'letter-spacing' => true,
            'line-height'    => true,
            'font-style'     => true,
            'font-size'      => false,
            'font-weight'    => true,
            'color'          => true,
            'text-align'     => false,
            'font-family'    => true,
            'all_styles'     => false,
            'default'     => array(
                'font-family' => 'Poppins',
                'font-weight' => '600',
                'text-transform' => 'none',
                'color' => '#002e5b',
                'line-height' => '24px',
                'letter-spacing' => '-0.7px'
            )
        ),
    ),
) );


/* =========================================================== */
/* 00. Shortcode Fonts 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Shortcode Fonts', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'subsection'      => true,
        'fields'    => array(

        // Testimonial
        array(
            'id'        => 'testimonial_fonts_info',
            'type'      => 'info',
            'desc'      => esc_html__('Testimonial Shortcode Typography.', 'pixomi'),
        ),

        array(
            'id'       =>'testimonial_fonts',
            'type'     => 'typography',
            'title'    => esc_html__('Testimonial Fonts', 'pixomi'),
            'desc'     => esc_html__('This Testimonial Typography Will be Applied on Testimonial Slider and Testimonial Box Shotcode.', 'pixomi'),
            'units'          => 'px',
            'google'         => true,
            'subsets'        => false,
            'text-transform' => false,
            'letter-spacing' => false,
            'font-style'     => true,
            'font-weight'    => true,
            'color'          => true,
            'text-align'     => false,
            'font-family'    => true,
            'font-size'      => true,
            'all_styles'     => true,
            'default'     => array(
                'font-family' => 'Lora',
                'font-weight' => '400',
                'font-size' => '19px',
                'line-height' => '33px',
                'font-style'  => 'italic',
                'color'  => '#35485a',
            )
        ),

        // Special Fonts
        array(
            'id'        => 'special_fonts_info',
            'type'      => 'info',
            'desc'      => esc_html__('Special Fonts Typography.', 'pixomi'),
        ),

        array(
            'id'       =>'special_fonts',
            'type'     => 'typography',
            'title'    => esc_html__('Special Fonts', 'pixomi'),
            'desc'     => esc_html__('This Special Typography Will be Applied on Buttons, pagination, Counter, Links and More .', 'pixomi'),
            'units'          => 'px',
            'google'         => true,
            'subsets'        => false,
            'text-transform' => false,
            'letter-spacing' => false,
            'line-height'    => false,
            'font-style'     => false,
            'font-weight'    => true,
            'color'          => false,
            'text-align'     => false,
            'font-family'    => true,
            'font-size'      => false,
            'all_styles'     => true,
            'default'     => array(
                'font-family' => 'Montserrat',
                'font-weight' => '700',
            )
        ),
    ),
) );

/* =========================================================== */
/* 00. Theme Styling 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Theme Styling', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'fields'    => array(

            array(
                'id'        => 'theme_colors_info',
                'type'      => 'info',
                'desc'      => esc_html__('Here You Can Choose Your Desired Theme Color.', 'pixomi'),
            ),

            array(
                'title' => esc_html__('Primary Color Scheme', 'pixomi'),
                'id'=>'primary_color',
                'type' => 'color',
                'transparent' => false,
                'validate' => 'color',
                'default' => '#11b5e6',
            ),
        ),

    ) );

/* =========================================================== */
/* 00. Blog  
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Blog  &amp;  News', 'pixomi'),
        'icon'      => 'el-icon-link',
        'fields'    => array(

        array(
            'id'        => 'main_blog_info',
            'type'      => 'info',
            'desc'      => esc_html__('Main Blog Settings Goes Here.', 'pixomi'),
        ),

        // Blog Style
        array(
            'id'       => 'blog_style',
            'type'     => 'select',
            'title'    => esc_html__('Blog and News Style', 'pixomi'), 
            'desc' => esc_html__('Select Your Desired Blog and News Style.', 'pixomi'),
            'options'  => array(
                'classic' => esc_html__('Classic Style', 'pixomi'),
                'list'    => esc_html__('List Style', 'pixomi'),
            ),
            'default'  => 'classic',
        ), 

        // Blog Layout
        array(
            'id'       => 'blog_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Blog and News Layout', 'pixomi'), 
            'subtitle' => esc_html__('Select Your Desired Blog and News layout.', 'pixomi'),
            'options'  => array(
                
                'right_sidebar' => array(
                    'title'     => esc_html__('Right Sidebar', 'pixomi'), 
                    'img'       => get_template_directory_uri().'/images/sidebars/right-sidebar.png'
                ),
                
                'left_sidebar'  => array(
                    'title'     => esc_html__('Left Sidebar', 'pixomi'), 
                    'img'       => get_template_directory_uri().'/images/sidebars/left-sidebar.png'
                ),

                'fullwidth'     => array(
                    'title'     => esc_html__('Fullwidth', 'pixomi'), 
                    'img'       => get_template_directory_uri().'/images/sidebars/default.png'
                ),
            ),
            'default'  => 'right_sidebar',
        ),

        // Switch Blog Share
        array(
            'id'      =>'switch_blog_share',
            'type'    => 'switch',
            'title'   => esc_html__('Enable Social Share Icons', 'pixomi'),
            'desc'   => esc_html__('Enable or Disable the Social Share Icons on Single Blog Layout', 'pixomi'),
            "default" => false,
        ), 

        ),
    ) );


/* =========================================================== */
/* 00. WooCommerce 
/* =========================================================== */
    if ( class_exists('Woocommerce') ) {
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('WooCommerce', 'pixomi'),
        'icon'      => 'el-icon-cog',
        'fields'    => array(

        // woo General
        array(
            'id'        => 'woo_general_info',
            'type'      => 'info',
            'desc'      => esc_html__('WooCommerce General', 'pixomi'),
        ), 

        // Switch Header Cart
        array(
            'id'      =>'switch_header_cart',
            'type'    => 'switch',
            'title'   => esc_html__('Enable Cart Icon on Header', 'pixomi'),
            "default" => true,
        ), 

        // Woo Shop
        array(
            'id'        => 'woo_shop_info',
            'type'      => 'info',
            'desc'      => esc_html__('WooCommerce Shop', 'pixomi'),
        ), 

        // Main Shop Layout
        array(  
            'id'       => 'woo_shop_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Woo Shop Layout', 'pixomi'), 
            'options'  => array(
                'fullwidth'  => array(
                    'title'   => esc_html__('No Sidebar', 'pixomi'), 
                    'img'  => get_template_directory_uri().'/images/sidebars/default.png'
                ),
                'right_sidebar' => array(
                    'title'   => esc_html__('Right Sidebar', 'pixomi'), 
                    'img'   => get_template_directory_uri().'/images/sidebars/right-sidebar.png'
                ),
                'left_sidebar' => array(
                    'title'   => esc_html__('Left Sidebar', 'pixomi'), 
                    'img'   => get_template_directory_uri().'/images/sidebars/left-sidebar.png'
                ),
            ),
            'default'  => 'right_sidebar',
        ),

        // Shop Product Columns
        array(
            'id'       => 'woo_product_columns',
            'type'     => 'select',
            'title'    => esc_html__('Products Per Column', 'pixomi'), 
            'desc' => esc_html__('Choose How Many Products You Want to Show in One Column.', 'pixomi'),
            'options'  => array(
                'columns-3'   => esc_html__('3 Columns', 'pixomi'),
                'columns-4'   => esc_html__('4 Columns', 'pixomi'),
            ),
            'select2' => array ( 'allowClear' => false ),
            'default'  => 'columns-3',
        ),  

         // Products Per Page
        array(
            'id'       => 'woo_product_numbers',
            'type'     => 'text',
            'title'    => esc_html__('Number of Products', 'pixomi'),
            'desc' => esc_html__('Choose How Many Products You Want to Show on Shop Page.', 'pixomi'),
            'default'  => '6'
        ),  

        // Woo Single Info
        array(
            'id'        => 'woo_single_info',
            'type'      => 'info',
            'desc'      => esc_html__('WooCommerce Single Product', 'pixomi')
        ),

       // Single Product Layout
        array(
            'id'       => 'woo_single_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Single Product Layout', 'pixomi'), 
            'options'  => array(
                'fullwidth'   => array(
                    'title'   => esc_html__('No Sidebar', 'pixomi'), 
                    'img'  => get_template_directory_uri().'/images/sidebars/default.png'
                ),
                'right_sidebar' => array(
                    'title'   => esc_html__('Right Sidebar', 'pixomi'), 
                    'img'   => get_template_directory_uri().'/images/sidebars/right-sidebar.png'
                ),
                'left_sidebar' => array(
                    'title'   => esc_html__('Left Sidebar', 'pixomi'), 
                    'img'   => get_template_directory_uri().'/images/sidebars/left-sidebar.png'
                ),
            ),
            'default'  => 'right_sidebar',
        ), 
        
        ),
    ) );
    }

/* =========================================================== */
/* 00. Social Media Links 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Social Media', 'pixomi'),
        'icon'      => 'el-icon-globe',
        'fields'    => array(

            array(
                'id'        => 'social_media_info',
                'type'      => 'info',
                'desc'      => esc_html__('All of Your Social Media Links Goes Here. If you Dont want to use any Social Link Just Leave it Blank.', 'pixomi')
            ),

            // Twitter
            array(
                'id'       => 'social_twitter',
                'type'     => 'text',
                'title'    => esc_html__('Twitter', 'pixomi'),
                'desc'     => esc_html__('Enter Twitter Profile Link', 'pixomi'),
            ),

            // Facebook
            array(
                'id'       => 'social_facebook',
                'type'     => 'text',
                'title'    => esc_html__('Facebook', 'pixomi'),
                'desc'     => esc_html__('Enter Facebook Profile Link', 'pixomi'),
            ),

            // Linkedin
            array(
                'id'       => 'social_linkedin',
                'type'     => 'text',
                'title'    => esc_html__('Linkedin', 'pixomi'),
                'desc'     => esc_html__('Enter Linkedin Profile Link', 'pixomi'),
            ),

            // Google Plus
            array(
                'id'       => 'social_googleplus',
                'type'     => 'text',
                'title'    => esc_html__('Google+', 'pixomi'),
                'desc'     => esc_html__('Enter Google+ Profile Link', 'pixomi'),
            ),

            // Instagram
            array(
                'id'       => 'social_instagram',
                'type'     => 'text',
                'title'    => esc_html__('Instagram', 'pixomi'),
                'desc'     => esc_html__('Enter Instagram Profile Link', 'pixomi'),
            ),

            // Pinterest
            array(
                'id'       => 'social_pinterest',
                'type'     => 'text',
                'title'    => esc_html__('Pinterest', 'pixomi'),
                'desc'     => esc_html__('Enter pinterest Profile Link', 'pixomi'),
            ),

            // Youtube
            array(
                'id'       => 'social_youtube',
                'type'     => 'text',
                'title'    => esc_html__('YouTube', 'pixomi'),
                'desc'     => esc_html__('Enter Youtube Channel Link', 'pixomi'),
            ),

            // Vimeo
            array(
                'id'       => 'social_vimeo',
                'type'     => 'text',
                'title'    => esc_html__('Vimeo', 'pixomi'),
                'desc'     => esc_html__('Enter Vimeo Channel Link', 'pixomi'),
            ),

            // Flickr
            array(
                'id'       => 'social_flickr',
                'type'     => 'text',
                'title'    => esc_html__('Flickr', 'pixomi'),
                'desc'    => esc_html__('Enter Flickr Profile Link', 'pixomi'),
            ),

            // Tumblr
            array(
                'id'       => 'social_tumblr',
                'type'     => 'text',
                'title'    => esc_html__('Tumblr', 'pixomi'),
                'desc'     => esc_html__('Enter Tumblr Profile Link', 'pixomi'),
            ),

            // Behance
            array(
                'id'       => 'social_behance',
                'type'     => 'text',
                'title'    => esc_html__('Behance', 'pixomi'),
                'desc'     => esc_html__('Enter Behance Profile Link', 'pixomi'),
            ),

            // Dribble
            array(
                'id'       => 'social_dribbble',
                'type'     => 'text',
                'title'    => esc_html__('Dribbble', 'pixomi'),
                'desc'     => esc_html__('Enter Dribble Profile Link', 'pixomi'),
            ),

            // Skype
            array(
                'id'       => 'social_skype',
                'type'     => 'text',
                'title'    => esc_html__('Skype', 'pixomi'),
                'desc'     => esc_html__('Enter Skype Username', 'pixomi'),
            ),

            // SoundCloud
            array(
                'id'       => 'social_soundcloud',
                'type'     => 'text',
                'title'    => esc_html__('SoundCloud', 'pixomi'),
                'desc'     => esc_html__('Enter SoundCloud Profile Link', 'pixomi'),
            ),

            // Github
            array(
                'id'       => 'social_github',
                'type'     => 'text',
                'title'    => esc_html__('Github', 'pixomi'),
                'desc'     => esc_html__('Enter Github Profile Link', 'pixomi'),
            ),

            // Foursquare
            array(
                'id'       => 'social_foursquare',
                'type'     => 'text',
                'title'    => esc_html__('FourSquare', 'pixomi'),
                'desc'     => esc_html__('Enter ForSquare Profile Link', 'pixomi'),
            ),

            // Rss Url
            array(
                'id'       => 'social_rss',
                'type'     => 'text',
                'title'    => esc_html__('RSS', 'pixomi'),
                'desc'     => esc_html__('Enter Your Website Rss url', 'pixomi'),
            ),

        ),
    ) );

/* =========================================================== */
/* 00. Import & Export 
/* =========================================================== */
   
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Import &amp; Backup', 'pixomi'),
        'icon'      => 'el-icon-folder-close',
        'fields'    => array(
        
        array(
            'id'            => 'import_export_field',
            'type'          => 'import_export',
            'title'         => esc_html__('&nbsp;', 'pixomi'),
            'subtitle'      => esc_html__('&nbsp;', 'pixomi'),
            'full_width'    => true,
        ),
        ),
    ) );
