<?php

/* =========================================================== */
/* 00. Register & Enqueue Styles 
/* =========================================================== */
if ( !function_exists( 'pixomi_register_theme_styles' ) ) {
    function pixomi_register_theme_styles() {

        wp_enqueue_style( 'pixomi-icons', get_template_directory_uri() . '/css/icons.css' );
        if ( class_exists( 'woocommerce' ) ) { 
        wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce.css' ); }
        wp_enqueue_style( 'pixomi-shortcodes', get_template_directory_uri() . '/css/shortcodes.css' );
        wp_register_style( 'pixomi-stylesheet', get_stylesheet_uri() );
        wp_enqueue_style( 'pixomi-stylesheet' );
    }
}
add_action( 'wp_enqueue_scripts', 'pixomi_register_theme_styles' );

/* =========================================================== */
/* 00. Register & Enqueue Scripts 
/* =========================================================== */
if ( !function_exists( 'pixomi_register_theme_scripts' ) ) {
    function pixomi_register_theme_scripts() {

        wp_enqueue_script( 'slick', get_template_directory_uri() . '/js/slick.min.js', array('jquery'), THEME_VERSION, true );
        wp_enqueue_script( 'jquery-easing', get_template_directory_uri() . '/js/jquery.easing.min.js', array('jquery'), THEME_VERSION, true );
        wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/isotope.min.js', array('jquery'), THEME_VERSION, true );
        wp_enqueue_script( 'pixomi-scripts', get_template_directory_uri() . '/js/functions.js', array('jquery'), THEME_VERSION, true );
        wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.min.js', array('jquery'), THEME_VERSION, true );
        if ( is_singular() ) { 
        wp_enqueue_script( 'comment-reply' ); }
    }
}    
add_action( 'wp_enqueue_scripts', 'pixomi_register_theme_scripts' );

/* =========================================================== */
/* 00. Include Theme Files 
/* =========================================================== */
require_once (get_template_directory() . '/functions/admin.php');
require_once ( get_template_directory() . '/functions/general.php' );
require_once ( get_template_directory() . '/plugins/plugins.php' );
require_once ( get_template_directory() . '/functions/dynamic.php' );
require_once ( get_template_directory() . '/functions/widget-info.php');
require_once ( get_template_directory() . '/functions/widget-social.php');
require_once ( get_template_directory() . '/functions/widget-posts.php');
require_once ( get_template_directory() . '/functions/tgm_class.php');
if(is_admin()) { 
    require_once ( get_template_directory(). '/functions/metaboxes.php' ); 
}
if ( class_exists('WPBakeryVisualComposerAbstract')) {
    require_once ( get_template_directory() . '/functions/vc_shortcodes.php'); 
}
if ( class_exists('woocommerce') ) {
    require get_template_directory() . '/functions/woo-config.php'; 
}

/* =========================================================== */
/* 00. Theme Support 
/* =========================================================== */
if ( !function_exists( 'pixomi_theme_support' ) ) {
    function pixomi_theme_support() {

        define( 'THEME_VERSION', '1.0' );
        if ( !isset( $content_width ) ) { $content_width = 847; }
        load_theme_textdomain( 'pixomi', get_template_directory() . '/lang' );

        add_editor_style( '/css/style-editor.css' );
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'title-tag' );
        add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'custom-header' );
        add_theme_support( 'custom-background' );
        add_theme_support( 'woocommerce' );
        add_theme_support( 'wc-product-gallery-lightbox' );

        add_image_size( 'pixomi-classic-blog', 1000, 450, true );           
        add_image_size( 'pixomi-list-blog', 600, 400, true );     
        add_image_size( 'pixomi-widget-post-thumb', 50, 50, true );     

        register_nav_menus( array(
            'pixomi-topbar_menu'        => esc_html__( 'Topbar Menu', 'pixomi' ),
            'pixomi-primary_menu'       => esc_html__( 'Primary Menu', 'pixomi' ),
            'pixomi-copyright_menu'     => esc_html__( 'Copyright Menu', 'pixomi' )
        ) );
    }
}
add_action( 'after_setup_theme', 'pixomi_theme_support' );

/* =========================================================== */
/* 00. Theme Sidebars 
/* =========================================================== */
function pixomi_widgets_init() {
    
    // Blog Widget Area
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Widget Area','pixomi' ), 
        'id'            => 'pixomi-blog_sidebar',
        'description'   => esc_html__( 'Blog Widget Area That Display on Blog Pages.','pixomi' ), 
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2>', 
        'after_title'   => '</h2>' 
    ));

    // Footer Widget Area
    register_sidebar(array( 
        'name'          => esc_html__('Footer Widget Area','pixomi' ), 
        'id'            => 'pixomi-footer_widget_area', 
        'description'   => esc_html__( 'Display Your Footer Widgets in This Column','pixomi' ), 
        'before_widget' => '<div id="%1$s" class="widget %2$s">', 
        'after_widget'  => '</div>', 
        'before_title'  => '<h2>', 
        'after_title'   => '</h2>' 
    ));

    // WooCommerce Widget Area
    if ( class_exists( 'woocommerce' ) ) {
        register_sidebar( array(
            'name'          => esc_html__('Shop Widget Area','pixomi' ), 
            'id'            => 'pixomi-shop_sidebar',
            'description'   => esc_html__( 'Shop Widget Ara That Display on Shop Pages.','pixomi' ), 
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2>', 
            'after_title'   => '</h2>' 
        ));
    }
}
add_action( 'widgets_init', 'pixomi_widgets_init' );
