<?php
if ( post_password_required() ) { return; } ?>
<div id="comments" class="comments-area">
	<?php if ( have_comments() ) : ?>
		<div class="comments-container">
			<h3 class="comment-title"><?php comments_number( esc_html__('Comments', 'pixomi'), esc_html__('1 Comment', 'pixomi'), esc_html__('% Comments', 'pixomi') );?></h3>
			<ul class="comment list">
				<?php wp_list_comments( array(
					'style'			 => 'ul',
					'format'		 => 'xhtml',
					'avatar_size'	 => 50,
					'short_ping'  	 => true,
					'reply_text'  => esc_html__( 'Reply', 'pixomi' ),
				) ); ?>
			</ul>
			<div class="comments-nav">
				<div class="pull-left prev-comments"><?php previous_comments_link(); ?></div>
				<div class="pull-right next_comments"><?php next_comments_link(); ?></div>
			</div>
		</div>
	<?php endif; ?>
		<?php if ( !comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
		<p class="no-comments"><?php echo esc_html_e( 'Comments are closed.', 'pixomi' ); ?></p>
	<?php endif; ?>
	<?php if ( comments_open() ) {
		$comments_args = array(
			'title_reply'			 => esc_html__( 'Leave a comment', 'pixomi' ),
			'title_reply_to'		 => esc_html__( 'Leave a comment', 'pixomi' ),
			'must_log_in'			 => '<p class="must-log-in">' . sprintf( __( 'You must be %slogged in%s to post a comment.', 'pixomi' ), '<a href="' . wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ) . '">', '</a>' ) . '</p>',
			'logged_in_as'			 => '<p class="logged-in-as">' . esc_html__( 'Logged in as', 'pixomi' ) . ' <a href="' . esc_url(admin_url("profile.php")) . '">' . $user_identity . '</a>. <a href="' . wp_logout_url( get_permalink() ) . '" title="' . esc_html__( 'Log out of this account', 'pixomi' ) . '">' . esc_html__( 'Log out &raquo;', 'pixomi' ) . '</a></p>',
			'comment_notes_before'	 => '',
			'comment_notes_after'	 => '',
			'comment_field'			 => '<div class="row">'
			. '<div class="col-md-12">'
			. '<div class="form-group">'
			. '<label class="sr-only" for="comment">' . esc_html__( 'Comment..', 'pixomi' ) . '</label>'
			. '<textarea name="comment" id="comment" class="form-control" rows="8" placeholder="' . esc_html__( 'Type Comment..', 'pixomi' ) . '"></textarea>'
			. '</div>'
			. '</div>'
			. '</div>',
			'id_submit'				 => 'comment-submit',
			'label_submit'			 => esc_html__( 'Post Comment', 'pixomi' ),
		);
		comment_form( $comments_args );
	} ?>
</div>